/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.scalar;

import io.protostuff.OutputEx;
import io.protostuff.compiler.model.Field;
import io.protostuff.runtime.FieldSchema;
import java.io.IOException;
import org.apache.servicecomb.foundation.common.utils.bean.BoolGetter;
import org.apache.servicecomb.foundation.common.utils.bean.Getter;
import org.apache.servicecomb.foundation.protobuf.internal.ProtoUtils;
import org.apache.servicecomb.foundation.protobuf.internal.bean.PropertyDescriptor;

public class BoolWriteSchemas {
    public static <T> FieldSchema<T> create(Field protoField, PropertyDescriptor propertyDescriptor) {
        if (Boolean.TYPE.equals(propertyDescriptor.getJavaType().getRawClass())) {
            return new BooleanPrimitiveSchema(protoField, propertyDescriptor);
        }
        if (Boolean.class.equals((Object)propertyDescriptor.getJavaType().getRawClass())) {
            return new BooleanSchema(protoField, propertyDescriptor);
        }
        return new BooleanSchema(protoField, propertyDescriptor);
    }

    private static class BooleanPrimitiveSchema<T>
    extends BooleanDynamicSchema<T> {
        private final BoolGetter<T> primitiveGetter;

        public BooleanPrimitiveSchema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor);
            this.primitiveGetter = (BoolGetter)propertyDescriptor.getGetter();
        }

        @Override
        public final void getAndWriteTo(OutputEx output, T message) throws IOException {
            boolean value = this.primitiveGetter.get(message);
            output.writeScalarBool(this.tag, this.tagSize, value);
        }
    }

    private static class BooleanSchema<T>
    extends BooleanDynamicSchema<T> {
        protected final Getter<T, Object> getter;

        public BooleanSchema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor);
            this.getter = (Getter)propertyDescriptor.getGetter();
        }

        @Override
        public final void getAndWriteTo(OutputEx output, T message) throws IOException {
            Object value = this.getter.get(message);
            if (value != null) {
                this.writeTo(output, value);
            }
        }
    }

    private static class BooleanDynamicSchema<T>
    extends FieldSchema<T> {
        public BooleanDynamicSchema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor.getJavaType());
        }

        @Override
        public final void writeTo(OutputEx output, Object value) throws IOException {
            if (value instanceof Boolean) {
                output.writeScalarBool(this.tag, this.tagSize, (Boolean)value);
                return;
            }
            if (value instanceof Number) {
                output.writeScalarBool(this.tag, this.tagSize, ((Number)value).longValue() == 1L);
                return;
            }
            if (value instanceof String[]) {
                if (((String[])value).length == 0) {
                    return;
                }
                boolean parsedValue = Boolean.parseBoolean(((String[])value)[0]);
                output.writeScalarBool(this.tag, this.tagSize, parsedValue);
                return;
            }
            if (value instanceof String) {
                boolean parsedValue = Boolean.parseBoolean((String)value);
                output.writeScalarBool(this.tag, this.tagSize, parsedValue);
                return;
            }
            ProtoUtils.throwNotSupportWrite(this.protoField, value);
        }
    }
}

