/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.exception;

import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.ws.rs.core.Response;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.servicecomb.config.inject.InjectProperties;
import org.apache.servicecomb.config.inject.InjectProperty;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.exception.ExceptionConverter;
import org.apache.servicecomb.core.exception.ExceptionProcessor;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.foundation.common.utils.SPIOrder;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.swagger.invocation.InvocationType;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.exception.CommonExceptionData;
import org.apache.servicecomb.swagger.invocation.exception.ExceptionFactory;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@InjectProperties(prefix="servicecomb.invocation.exception")
public class DefaultExceptionProcessor
implements ExceptionProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExceptionProcessor.class);
    public static final int ORDER = Integer.MAX_VALUE;
    @JsonIgnore
    private final List<ExceptionConverter<Throwable>> converters = SPIServiceUtils.getOrLoadSortedService(ExceptionConverter.class).stream().map(converter -> converter).collect(Collectors.toList());
    @InjectProperty(keys={"print-stack-trace"}, defaultValue="false")
    protected boolean printStackTrace;
    @InjectProperty(keys={"print-rate-limit"}, defaultValue="false")
    protected boolean printRateLimit;
    private final Map<Class<?>, ExceptionConverter<Throwable>> converterCache = new ConcurrentHashMapEx();

    @Override
    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isPrintStackTrace() {
        return this.printStackTrace;
    }

    public DefaultExceptionProcessor setPrintStackTrace(boolean printStackTrace) {
        this.printStackTrace = printStackTrace;
        return this;
    }

    public boolean isPrintRateLimit() {
        return this.printRateLimit;
    }

    public DefaultExceptionProcessor setPrintRateLimit(boolean printRateLimit) {
        this.printRateLimit = printRateLimit;
        return this;
    }

    @Autowired(required=false)
    public DefaultExceptionProcessor setConverters(List<ExceptionConverter<? extends Throwable>> converters) {
        converters.forEach(converter -> this.converters.add((ExceptionConverter<Throwable>)converter));
        this.converters.sort(Comparator.comparingInt(SPIOrder::getOrder));
        this.converterCache.clear();
        return this;
    }

    @Override
    public InvocationException convert(@Nonnull Invocation invocation, Throwable throwable) {
        Response.Status genericStatus = InvocationType.CONSUMER.equals((Object)invocation.getInvocationType()) ? Response.Status.BAD_REQUEST : Response.Status.INTERNAL_SERVER_ERROR;
        return this.convert(invocation, throwable, (Response.StatusType)genericStatus);
    }

    @Override
    public InvocationException convert(@Nullable Invocation invocation, Throwable throwable, Response.StatusType genericStatus) {
        Throwable unwrapped = ExceptionFactory.unwrap((Throwable)throwable);
        try {
            return this.converterCache.computeIfAbsent(unwrapped.getClass(), clazz -> this.findConverter(unwrapped)).convert(invocation, unwrapped, genericStatus);
        }
        catch (Exception e) {
            LOGGER.error("BUG: ExceptionConverter.convert MUST not throw exception, please fix it.\noriginal exception :{}converter exception:{}", (Object)ExceptionUtils.getStackTrace((Throwable)throwable), (Object)ExceptionUtils.getStackTrace((Throwable)e));
            return new InvocationException((Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, (Object)new CommonExceptionData("SCB.50000000", Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase()));
        }
    }

    private ExceptionConverter<Throwable> findConverter(Throwable throwable) {
        for (ExceptionConverter<Throwable> converter : this.converters) {
            if (!converter.canConvert(throwable)) continue;
            return converter;
        }
        throw new IllegalStateException("never happened: can not find converter for " + throwable.getClass().getName());
    }

    @Override
    public Response toConsumerResponse(Invocation invocation, Throwable throwable) {
        InvocationException exception = this.convert(invocation, throwable, (Response.StatusType)Response.Status.BAD_REQUEST);
        this.logConsumerException(invocation, exception);
        return Response.failResp((InvocationException)exception);
    }

    @Override
    public void logConsumerException(@Nonnull Invocation invocation, @Nonnull InvocationException exception) {
        if (this.isIgnoreLog(invocation, exception)) {
            return;
        }
        if (this.isPrintStackTrace()) {
            LOGGER.error("failed to invoke {}, endpoint={}, trace id={}.", new Object[]{invocation.getMicroserviceQualifiedName(), invocation.getEndpoint(), invocation.getTraceId(), exception});
            return;
        }
        LOGGER.error("failed to invoke {}, endpoint={}, trace id={}, message={}.", new Object[]{invocation.getMicroserviceQualifiedName(), invocation.getEndpoint(), invocation.getTraceId(), org.apache.servicecomb.foundation.common.utils.ExceptionUtils.getExceptionMessageWithoutTrace((Throwable)exception)});
    }

    @Override
    public boolean isIgnoreLog(@Nonnull Invocation invocation, @Nonnull InvocationException exception) {
        return !this.isPrintRateLimit() && exception.getStatusCode() == Response.Status.TOO_MANY_REQUESTS.getStatusCode();
    }

    @Override
    public Response toProducerResponse(@Nullable Invocation invocation, Throwable exception) {
        InvocationException invocationException = this.convert(invocation, exception, (Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR);
        if (invocation != null) {
            this.logProducerException(invocation, invocationException);
        }
        return Response.status((Response.StatusType)invocationException.getStatus()).entity(invocationException.getErrorData());
    }

    @Override
    public void logProducerException(@Nonnull Invocation invocation, @Nonnull InvocationException exception) {
        if (this.isIgnoreLog(invocation, exception)) {
            return;
        }
        if (this.isPrintStackTrace()) {
            LOGGER.error("failed to process {} invocation, operation={}.", new Object[]{invocation.getInvocationType(), invocation.getMicroserviceQualifiedName(), exception});
            return;
        }
        LOGGER.error("failed to process {} invocation, operation={}, message={}.", new Object[]{invocation.getInvocationType(), invocation.getMicroserviceQualifiedName(), org.apache.servicecomb.foundation.common.utils.ExceptionUtils.getExceptionMessageWithoutTrace((Throwable)exception)});
    }
}

