/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.registry.discovery;

import com.netflix.config.DynamicPropertyFactory;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.definition.CoreMetaUtils;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.foundation.common.cache.VersionedCache;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.registry.DiscoveryManager;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.registry.consumer.AppManager;
import org.apache.servicecomb.registry.consumer.MicroserviceVersion;
import org.apache.servicecomb.registry.consumer.MicroserviceVersions;
import org.apache.servicecomb.registry.discovery.AbstractDiscoveryFilter;
import org.apache.servicecomb.registry.discovery.DiscoveryContext;
import org.apache.servicecomb.registry.discovery.DiscoveryTreeNode;
import org.apache.servicecomb.registry.version.VersionRule;
import org.apache.servicecomb.registry.version.VersionRuleUtils;

public class OperationInstancesDiscoveryFilter
extends AbstractDiscoveryFilter {
    public int getOrder() {
        return -20000;
    }

    public boolean enabled() {
        return DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.loadbalance.filter.operation.enabled", false).get();
    }

    public boolean isGroupingFilter() {
        return true;
    }

    protected String findChildName(DiscoveryContext context, DiscoveryTreeNode parent) {
        Invocation invocation = (Invocation)((Object)context.getInputParameters());
        return invocation.getMicroserviceQualifiedName();
    }

    public void init(DiscoveryContext context, DiscoveryTreeNode parent) {
        Invocation invocation = (Invocation)((Object)context.getInputParameters());
        List<MicroserviceVersion> microserviceVersions = this.sortedMicroserviceVersion(invocation, (Map)parent.data());
        ConcurrentHashMapEx operationNodes = new ConcurrentHashMapEx();
        for (MicroserviceVersion microserviceVersion : microserviceVersions) {
            MicroserviceMeta microserviceMeta = CoreMetaUtils.getMicroserviceMeta(microserviceVersion);
            for (OperationMeta operationMeta : microserviceMeta.getOperations()) {
                DiscoveryTreeNode node = (DiscoveryTreeNode)operationNodes.get(operationMeta.getMicroserviceQualifiedName());
                if (node == null) {
                    Map instanceMap = microserviceVersion.getInstances().stream().collect(Collectors.toMap(MicroserviceInstance::getInstanceId, Function.identity()));
                    DiscoveryTreeNode tempNode = this.createOperationNode(parent, microserviceVersion);
                    tempNode.data(instanceMap);
                    operationNodes.put(operationMeta.getMicroserviceQualifiedName(), tempNode);
                    continue;
                }
                microserviceVersion.getInstances().forEach(microserviceInstance -> node.mapData().put(microserviceInstance.getInstanceId(), microserviceInstance));
            }
        }
        parent.children((Map)operationNodes);
    }

    protected List<MicroserviceVersion> sortedMicroserviceVersion(Invocation invocation, Map<String, MicroserviceInstance> instances) {
        OperationMeta latestOperationMeta = invocation.getOperationMeta();
        MicroserviceMeta latestMicroserviceMeta = latestOperationMeta.getSchemaMeta().getMicroserviceMeta();
        AppManager appManager = DiscoveryManager.INSTANCE.getAppManager();
        MicroserviceVersions microserviceVersions = appManager.getOrCreateMicroserviceVersions(latestMicroserviceMeta.getAppId(), latestMicroserviceMeta.getMicroserviceName());
        HashMap<String, MicroserviceVersion> uniqueMicroserviceVersion = new HashMap<String, MicroserviceVersion>();
        for (MicroserviceInstance instance : instances.values()) {
            MicroserviceVersion microserviceVersion = microserviceVersions.getVersion(instance.getServiceId());
            uniqueMicroserviceVersion.put(instance.getServiceId(), microserviceVersion);
        }
        return uniqueMicroserviceVersion.values().stream().sorted(Comparator.comparing(MicroserviceVersion::getVersion)).collect(Collectors.toList());
    }

    private DiscoveryTreeNode createOperationNode(DiscoveryTreeNode parent, MicroserviceVersion microserviceVersion) {
        VersionRule versionRule = VersionRuleUtils.getOrCreate((String)(microserviceVersion.getVersion().getVersion() + "+"));
        return (DiscoveryTreeNode)new DiscoveryTreeNode().subName((VersionedCache)parent, versionRule.getVersionRule()).data(new HashMap());
    }
}

