/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.transport;

import io.vertx.core.Vertx;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.apache.servicecomb.core.Endpoint;
import org.apache.servicecomb.core.Transport;
import org.apache.servicecomb.foundation.common.net.NetUtils;
import org.apache.servicecomb.foundation.common.net.URIEndpointObject;
import org.apache.servicecomb.foundation.vertx.SharedVertxFactory;
import org.apache.servicecomb.registry.RegistrationManager;

public abstract class AbstractTransport
implements Transport {
    public static final String ENDPOINT_KEY = "servicecomb.endpoint";
    protected Vertx transportVertx = SharedVertxFactory.getSharedVertx();
    protected Endpoint endpoint;
    protected Endpoint publishEndpoint;

    @Override
    public Endpoint getPublishEndpoint() {
        return this.publishEndpoint;
    }

    @Override
    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    protected void setListenAddressWithoutSchema(String addressWithoutSchema) {
        this.setListenAddressWithoutSchema(addressWithoutSchema, null);
    }

    protected void setListenAddressWithoutSchema(String addressWithoutSchema, Map<String, String> pairs) {
        addressWithoutSchema = this.genAddressWithoutSchema(addressWithoutSchema, pairs);
        this.endpoint = new Endpoint(this, NetUtils.getRealListenAddress((String)this.getName(), (String)addressWithoutSchema));
        this.publishEndpoint = this.endpoint.getEndpoint() != null ? new Endpoint(this, RegistrationManager.getPublishAddress((String)this.getName(), (String)addressWithoutSchema)) : null;
    }

    private String genAddressWithoutSchema(String addressWithoutSchema, Map<String, String> pairs) {
        if (addressWithoutSchema == null || pairs == null || pairs.isEmpty()) {
            return addressWithoutSchema;
        }
        int idx = ((String)addressWithoutSchema).indexOf(63);
        addressWithoutSchema = idx == -1 ? (String)addressWithoutSchema + "?" : (String)addressWithoutSchema + "&";
        String encodedQuery = URLEncodedUtils.format(pairs.entrySet().stream().map(entry -> new BasicNameValuePair((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList()), (String)StandardCharsets.UTF_8.name());
        addressWithoutSchema = (String)addressWithoutSchema + encodedQuery;
        return addressWithoutSchema;
    }

    @Override
    public Object parseAddress(String address) {
        if (address == null) {
            return null;
        }
        return new URIEndpointObject(address);
    }
}

