/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.bean;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.servicecomb.foundation.common.utils.LambdaMetafactoryUtils;
import org.apache.servicecomb.foundation.protobuf.internal.bean.PropertyDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(BeanDescriptor.class);
    private JavaType javaType;
    private final Map<String, PropertyDescriptor> propertyDescriptors = new HashMap<String, PropertyDescriptor>();

    public JavaType getJavaType() {
        return this.javaType;
    }

    public Map<String, PropertyDescriptor> getPropertyDescriptors() {
        return this.propertyDescriptors;
    }

    public void init(SerializationConfig serializationConfig, JavaType javaType) {
        this.javaType = javaType;
        BeanDescription beanDescription = serializationConfig.introspect(javaType);
        for (BeanPropertyDefinition propertyDefinition : beanDescription.findProperties()) {
            PropertyDescriptor propertyDescriptor = new PropertyDescriptor();
            propertyDescriptor.setName(propertyDefinition.getName());
            propertyDescriptor.setJavaType(propertyDefinition.getPrimaryType());
            try {
                propertyDescriptor.setGetter(BeanDescriptor.initGetter(propertyDefinition));
            }
            catch (Throwable e) {
                LOGGER.error("failed to init getter for field {}:{}", new Object[]{javaType.getRawClass().getName(), propertyDefinition.getName(), e});
            }
            try {
                propertyDescriptor.setSetter(this.initSetter(propertyDefinition));
            }
            catch (Throwable e) {
                LOGGER.error("failed to init setter for field {}:{}", new Object[]{javaType.getRawClass().getName(), propertyDefinition.getName(), e});
            }
            this.propertyDescriptors.put(propertyDefinition.getName(), propertyDescriptor);
        }
    }

    public static <T> T initGetter(BeanPropertyDefinition propertyDefinition) {
        if (propertyDefinition.hasGetter()) {
            return (T)LambdaMetafactoryUtils.createGetter((Method)propertyDefinition.getGetter().getAnnotated());
        }
        if (propertyDefinition.hasField() && propertyDefinition.getField().isPublic()) {
            return (T)LambdaMetafactoryUtils.createGetter((Field)propertyDefinition.getField().getAnnotated());
        }
        return null;
    }

    protected Object initSetter(BeanPropertyDefinition propertyDefinition) {
        if (propertyDefinition.hasSetter()) {
            return LambdaMetafactoryUtils.createSetter((Method)propertyDefinition.getSetter().getAnnotated());
        }
        if (propertyDefinition.hasField() && propertyDefinition.getField().isPublic()) {
            return LambdaMetafactoryUtils.createSetter((Field)propertyDefinition.getField().getAnnotated());
        }
        return null;
    }
}

