/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.parser;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.protostuff.compiler.ParserModule;
import io.protostuff.compiler.model.Proto;
import io.protostuff.compiler.parser.FileDescriptorLoader;
import io.protostuff.compiler.parser.FileReader;
import io.protostuff.compiler.parser.FileReaderFactory;
import io.protostuff.compiler.parser.ProtoContext;
import java.util.Collections;
import org.apache.servicecomb.foundation.protobuf.internal.parser.ContentFileReader;

public class ProtoParser {
    private static final String DEFAULT_PROTO_NAME = "default.proto";
    private final Injector injector = Guice.createInjector((Module[])new Module[]{new ParserModule()});
    private final FileReaderFactory fileReaderFactory = (FileReaderFactory)this.injector.getInstance(FileReaderFactory.class);
    private final FileReader defaultReader = this.fileReaderFactory.create(Collections.emptyList());
    private final FileDescriptorLoader loader = (FileDescriptorLoader)this.injector.getInstance(FileDescriptorLoader.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Proto parseFromContent(String content) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            if (classLoader == null) {
                Thread.currentThread().setContextClassLoader(ProtoParser.class.getClassLoader());
            }
            ProtoContext context = this.loader.load((FileReader)new ContentFileReader(this.defaultReader, content), DEFAULT_PROTO_NAME);
            Proto proto = context.getProto();
            return proto;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Proto parse(String name) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            if (classLoader == null) {
                Thread.currentThread().setContextClassLoader(ProtoParser.class.getClassLoader());
            }
            ProtoContext context = this.loader.load(this.defaultReader, name);
            Proto proto = context.getProto();
            return proto;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }
}

