/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.codec.produce;

import com.fasterxml.jackson.databind.JavaType;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Schema;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.HashMap;
import org.apache.servicecomb.codec.protobuf.utils.ScopedProtobufSchemaManager;
import org.apache.servicecomb.common.rest.codec.produce.ProduceProcessor;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.foundation.protobuf.ProtoMapper;
import org.apache.servicecomb.foundation.protobuf.RootDeserializer;
import org.apache.servicecomb.foundation.protobuf.RootSerializer;
import org.apache.servicecomb.foundation.protobuf.internal.bean.PropertyWrapper;

public class ProduceProtoBufferProcessor
implements ProduceProcessor {
    public static final String RESPONSE_MESSAGE_NAME = "X_RESPONSE";
    public static final String EXT_ID = "protobuf";
    private static final Object LOCK = new Object();
    private final OperationMeta operationMeta;
    private final OpenAPI openAPI;
    private final Schema<?> schema;
    private final ScopedProtobufSchemaManager scopedProtobufSchemaManager;

    public ProduceProtoBufferProcessor(OperationMeta operationMeta, OpenAPI openAPI, Schema<?> schema) {
        this.operationMeta = operationMeta;
        this.openAPI = openAPI;
        this.schema = schema;
        this.scopedProtobufSchemaManager = this.getOrCreateScopedProtobufSchemaManager(operationMeta.getMicroserviceMeta());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScopedProtobufSchemaManager getOrCreateScopedProtobufSchemaManager(MicroserviceMeta microserviceMeta) {
        ScopedProtobufSchemaManager scopedProtobufSchemaManager = (ScopedProtobufSchemaManager)microserviceMeta.getExtData(EXT_ID);
        if (scopedProtobufSchemaManager == null) {
            Object object = LOCK;
            synchronized (object) {
                scopedProtobufSchemaManager = (ScopedProtobufSchemaManager)microserviceMeta.getExtData(EXT_ID);
                if (scopedProtobufSchemaManager == null) {
                    scopedProtobufSchemaManager = new ScopedProtobufSchemaManager();
                    microserviceMeta.putExtData(EXT_ID, (Object)scopedProtobufSchemaManager);
                }
            }
        }
        return scopedProtobufSchemaManager;
    }

    @Override
    public String getName() {
        return "application/protobuf";
    }

    @Override
    public int getOrder() {
        return 0;
    }

    @Override
    public void doEncodeResponse(OutputStream output, Object result) throws Exception {
        ProtoMapper protoMapper = this.scopedProtobufSchemaManager.getOrCreateProtoMapper(this.openAPI, this.operationMeta.getSchemaId(), RESPONSE_MESSAGE_NAME, this.schema);
        RootSerializer serializer = protoMapper.getSerializerSchemaManager().createRootSerializer(protoMapper.getProto().getMessage(RESPONSE_MESSAGE_NAME), Object.class);
        HashMap<String, Object> bodyArg = new HashMap<String, Object>(1);
        bodyArg.put("value", result);
        output.write(serializer.serialize(bodyArg));
    }

    @Override
    public Object doDecodeResponse(InputStream input, JavaType type) throws Exception {
        ProtoMapper protoMapper = this.scopedProtobufSchemaManager.getOrCreateProtoMapper(this.openAPI, this.operationMeta.getSchemaId(), RESPONSE_MESSAGE_NAME, this.schema);
        RootDeserializer deserializer = protoMapper.getDeserializerSchemaManager().createRootDeserializer(protoMapper.getProto().getMessage(RESPONSE_MESSAGE_NAME), (Type)type);
        PropertyWrapper result = (PropertyWrapper)deserializer.deserialize(input.readAllBytes());
        return result.getValue();
    }
}

