/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.bootstrap;

import java.util.Collections;
import java.util.List;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.bootstrap.SCBEngineForTest;
import org.apache.servicecomb.core.executor.ExecutorManager;
import org.apache.servicecomb.core.provider.LocalOpenAPIRegistry;
import org.apache.servicecomb.core.provider.OpenAPIRegistryManager;
import org.apache.servicecomb.core.provider.consumer.ConsumerProviderManager;
import org.apache.servicecomb.core.transport.TransportManager;
import org.apache.servicecomb.foundation.common.LegacyPropertyFactory;
import org.apache.servicecomb.registry.DiscoveryManager;
import org.apache.servicecomb.registry.RegistrationManager;
import org.apache.servicecomb.registry.discovery.TelnetInstancePing;
import org.springframework.core.env.Environment;

public class SCBBootstrap {
    public static SCBEngine createSCBEngineForTest(Environment environment) {
        LegacyPropertyFactory.setEnvironment((Environment)environment);
        RegistrationManager registrationManager = new RegistrationManager(Collections.emptyList());
        DiscoveryManager discoveryManager = new DiscoveryManager(Collections.emptyList(), List.of(new TelnetInstancePing()));
        registrationManager.init();
        discoveryManager.init();
        SCBEngineForTest result = new SCBEngineForTest(environment);
        result.setDiscoveryManager(discoveryManager);
        result.setRegistrationManager(registrationManager);
        result.setBootListeners(Collections.emptyList());
        result.setBootUpInformationCollectors(Collections.emptyList());
        result.setExecutorManager(new ExecutorManager());
        result.setTransportManager(new TransportManager());
        result.setEnvironment(environment);
        OpenAPIRegistryManager openAPIRegistryManager = new OpenAPIRegistryManager();
        openAPIRegistryManager.setOpenAPIRegistries(List.of(new LocalOpenAPIRegistry(environment)));
        result.setConsumerProviderManager(new ConsumerProviderManager(environment, openAPIRegistryManager));
        result.setOpenAPIRegistryManager(openAPIRegistryManager);
        return result;
    }
}

