/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.definition;

import io.swagger.v3.oas.models.OpenAPI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.definition.MicroserviceVersionsMeta;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.core.definition.SchemaMeta;
import org.apache.servicecomb.core.filter.FilterNode;
import org.apache.servicecomb.foundation.common.VendorExtensions;

public class MicroserviceMeta {
    private final SCBEngine scbEngine;
    private MicroserviceVersionsMeta microserviceVersionsMeta;
    private final String appId;
    private final String microserviceName;
    private final Map<String, SchemaMeta> schemaMetas = new HashMap<String, SchemaMeta>();
    private final Map<String, OperationMeta> operationMetas = new HashMap<String, OperationMeta>();
    private final boolean consumer;
    private FilterNode consumerFilterChain = FilterNode.EMPTY;
    private FilterNode providerFilterChain = FilterNode.EMPTY;
    private FilterNode edgeFilterChain = FilterNode.EMPTY;
    private final VendorExtensions vendorExtensions = new VendorExtensions();

    public MicroserviceMeta(SCBEngine scbEngine, String application, String serviceName, boolean consumer) {
        this.scbEngine = scbEngine;
        this.appId = application;
        this.microserviceName = serviceName;
        this.consumer = consumer;
    }

    public MicroserviceVersionsMeta getMicroserviceVersionsMeta() {
        return this.microserviceVersionsMeta;
    }

    public void setMicroserviceVersionsMeta(MicroserviceVersionsMeta microserviceVersionsMeta) {
        this.microserviceVersionsMeta = microserviceVersionsMeta;
    }

    public SCBEngine getScbEngine() {
        return this.scbEngine;
    }

    public boolean isConsumer() {
        return this.consumer;
    }

    public String getMicroserviceName() {
        return this.microserviceName;
    }

    public String getAppId() {
        return this.appId;
    }

    public SchemaMeta registerSchemaMeta(String schemaId, OpenAPI swagger) {
        SchemaMeta schemaMeta = new SchemaMeta(this, schemaId, swagger);
        if (this.schemaMetas.putIfAbsent(schemaMeta.getSchemaId(), schemaMeta) != null) {
            throw new IllegalStateException(String.format("failed to register SchemaMeta caused by duplicated schemaId, appId=%s, microserviceName=%s, schemaId=%s.", this.appId, this.microserviceName, schemaMeta.getSchemaId()));
        }
        schemaMeta.getOperations().values().forEach(operationMeta -> this.operationMetas.put(operationMeta.getMicroserviceQualifiedName(), (OperationMeta)operationMeta));
        return schemaMeta;
    }

    public Map<String, OperationMeta> operationMetas() {
        return this.operationMetas;
    }

    public Collection<OperationMeta> getOperations() {
        return this.operationMetas.values();
    }

    public SchemaMeta ensureFindSchemaMeta(String schemaId) {
        SchemaMeta schemaMeta = this.schemaMetas.get(schemaId);
        if (schemaMeta == null) {
            throw new IllegalStateException(String.format("failed to find SchemaMeta by schemaId, appId=%s, microserviceName=%s, schemaId=%s.", this.appId, this.microserviceName, schemaId));
        }
        return schemaMeta;
    }

    public SchemaMeta findSchemaMeta(String schemaId) {
        return this.schemaMetas.get(schemaId);
    }

    public Map<String, SchemaMeta> getSchemaMetas() {
        return this.schemaMetas;
    }

    public void putExtData(String key, Object data) {
        this.vendorExtensions.put((Object)key, data);
    }

    public <T> T getExtData(String key) {
        return (T)this.vendorExtensions.get((Object)key);
    }

    public FilterNode getConsumerFilterChain() {
        return this.consumerFilterChain;
    }

    public void setConsumerFilterChain(FilterNode consumerFilterChain) {
        this.consumerFilterChain = consumerFilterChain;
    }

    public FilterNode getProviderFilterChain() {
        return this.providerFilterChain;
    }

    public void setProviderFilterChain(FilterNode providerFilterChain) {
        this.providerFilterChain = providerFilterChain;
    }

    public FilterNode getEdgeFilterChain() {
        return this.edgeFilterChain;
    }

    public void setEdgeFilterChain(FilterNode edgeFilterChain) {
        this.edgeFilterChain = edgeFilterChain;
    }
}

