/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.loadbalance;

import java.util.List;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.loadbalance.ExtensionsFactory;
import org.apache.servicecomb.loadbalance.ExtensionsManager;
import org.apache.servicecomb.loadbalance.LoadBalanceFilter;
import org.apache.servicecomb.loadbalance.RuleNameExtensionsFactory;
import org.apache.servicecomb.loadbalance.filter.InstancePropertyDiscoveryFilter;
import org.apache.servicecomb.loadbalance.filter.PriorityInstancePropertyDiscoveryFilter;
import org.apache.servicecomb.loadbalance.filter.ServerDiscoveryFilter;
import org.apache.servicecomb.loadbalance.filter.ZoneAwareDiscoveryFilter;
import org.apache.servicecomb.registry.discovery.DiscoveryTree;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"servicecomb.loadbalance.enabled"}, havingValue="true", matchIfMissing=true)
public class LoadBalanceConfiguration {
    public static final String LOAD_BALANCE_PREFIX = "servicecomb.loadbalance";
    public static final String LOAD_BALANCE_ENABLED = "servicecomb.loadbalance.enabled";

    @Bean
    public LoadBalanceFilter scbLoadBalanceFilter(ExtensionsManager extensionsManager, DiscoveryTree discoveryTree, SCBEngine scbEngine) {
        return new LoadBalanceFilter(extensionsManager, discoveryTree, scbEngine);
    }

    @Bean
    public RuleNameExtensionsFactory scbRuleNameExtensionsFactory() {
        return new RuleNameExtensionsFactory();
    }

    @Bean
    public ExtensionsManager scbExtensionsManager(List<ExtensionsFactory> extensionsFactories) {
        return new ExtensionsManager(extensionsFactories);
    }

    @Bean
    public PriorityInstancePropertyDiscoveryFilter scbPriorityInstancePropertyDiscoveryFilter() {
        return new PriorityInstancePropertyDiscoveryFilter();
    }

    @Bean
    public InstancePropertyDiscoveryFilter scbInstancePropertyDiscoveryFilter() {
        return new InstancePropertyDiscoveryFilter();
    }

    @Bean
    public ServerDiscoveryFilter scbServerDiscoveryFilter() {
        return new ServerDiscoveryFilter();
    }

    @Bean
    public ZoneAwareDiscoveryFilter scbZoneAwareDiscoveryFilter() {
        return new ZoneAwareDiscoveryFilter();
    }
}

