/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.codec.protobuf.internal.converter;

import com.google.common.hash.Hashing;
import io.protostuff.compiler.model.Message;
import io.protostuff.compiler.model.Proto;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.vertx.core.json.Json;
import jakarta.ws.rs.core.Response;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.codec.protobuf.internal.converter.ProtoMethod;
import org.apache.servicecomb.codec.protobuf.internal.converter.ProtoResponse;
import org.apache.servicecomb.codec.protobuf.internal.converter.SwaggerTypeAdapter;
import org.apache.servicecomb.foundation.common.utils.StringBuilderUtils;
import org.apache.servicecomb.foundation.protobuf.internal.ProtoConst;
import org.apache.servicecomb.foundation.protobuf.internal.parser.ProtoParser;
import org.apache.servicecomb.swagger.generator.SwaggerConst;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerToProtoGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwaggerToProtoGenerator.class);
    private final String protoPackage;
    private final OpenAPI swagger;
    private final StringBuilder msgStringBuilder = new StringBuilder();
    private final StringBuilder serviceBuilder = new StringBuilder();
    private final Set<String> imports = new HashSet<String>();
    private final Set<String> messages = new HashSet<String>();
    private List<Runnable> pending = new ArrayList<Runnable>();

    public SwaggerToProtoGenerator(String protoPackage, OpenAPI swagger) {
        this.protoPackage = SwaggerToProtoGenerator.escapePackageName(protoPackage);
        this.swagger = swagger;
    }

    public Proto convert() {
        this.convertDefinitions();
        this.convertOperations();
        do {
            List<Runnable> oldPending = this.pending;
            this.pending = new ArrayList<Runnable>();
            for (Runnable runnable : oldPending) {
                runnable.run();
            }
        } while (!this.pending.isEmpty());
        return this.createProto();
    }

    public static String escapePackageName(String name) {
        return name.replaceAll("[\\-:]", "_");
    }

    public static String escapeMessageName(String name) {
        return name.replaceAll("\\.", "_");
    }

    public static boolean isValidEnum(String name) {
        return !name.contains(".") && !name.contains("-");
    }

    private void convertDefinitions() {
        if (this.swagger.getComponents() == null || this.swagger.getComponents().getSchemas() == null) {
            return;
        }
        for (Map.Entry entry : this.swagger.getComponents().getSchemas().entrySet()) {
            this.convertDefinition((String)entry.getKey(), (Schema)entry.getValue());
        }
    }

    private void convertDefinition(String modelName, Schema model) {
        Map<String, Schema> properties = model.getProperties();
        if (properties == null) {
            properties = Collections.emptyMap();
        }
        this.createMessage(modelName, properties, new String[0]);
    }

    private void createMessage(String protoName, Map<String, Schema> properties, String ... annotations) {
        if (!this.messages.add(protoName)) {
            return;
        }
        for (String annotation : annotations) {
            this.msgStringBuilder.append("//");
            StringBuilderUtils.appendLine((StringBuilder)this.msgStringBuilder, (String)annotation, (Object[])new Object[0]);
        }
        StringBuilderUtils.appendLine((StringBuilder)this.msgStringBuilder, (String)"message %s {", (Object[])new Object[]{protoName});
        int tag = 1;
        for (Map.Entry<String, Schema> entry : properties.entrySet()) {
            Schema property = entry.getValue();
            String propertyType = this.convertSwaggerType(property);
            StringBuilderUtils.appendLine((StringBuilder)this.msgStringBuilder, (String)"  %s %s = %d;", (Object[])new Object[]{propertyType, entry.getKey(), tag});
            ++tag;
        }
        StringBuilderUtils.appendLine((StringBuilder)this.msgStringBuilder, (String)"}", (Object[])new Object[0]);
    }

    private void addImports(Proto proto) {
        this.imports.add(proto.getFilename());
        for (Message message : proto.getMessages()) {
            this.messages.add(message.getCanonicalName());
        }
    }

    private String convertSwaggerType(Object swaggerType) {
        if (swaggerType == null) {
            this.addImports(ProtoConst.EMPTY_PROTO);
            return ProtoConst.EMPTY.getCanonicalName();
        }
        SwaggerTypeAdapter adapter = SwaggerTypeAdapter.create(swaggerType);
        String type = this.tryFindEnumType(adapter.getEnum());
        if (type != null) {
            return type;
        }
        type = this.findBaseType(adapter.getType(), adapter.getFormat());
        if (type != null) {
            return type;
        }
        type = adapter.getRefType();
        if (type != null) {
            return type.substring("#/components/schemas/".length());
        }
        Schema<?> itemProperty = adapter.getArrayItem();
        if (itemProperty != null) {
            return "repeated " + this.convertArrayOrMapItem(itemProperty);
        }
        itemProperty = adapter.getMapItem();
        if (itemProperty != null) {
            return String.format("map<string, %s>", this.convertArrayOrMapItem(itemProperty));
        }
        if (adapter.isJavaLangObject()) {
            this.addImports(ProtoConst.ANY_PROTO);
            return ProtoConst.ANY.getCanonicalName();
        }
        throw new IllegalStateException(String.format("not support swagger type, class=%s, content=%s.", swaggerType.getClass().getName(), Json.encode((Object)swaggerType)));
    }

    private String convertArrayOrMapItem(Schema itemProperty) {
        SwaggerTypeAdapter itemAdapter = SwaggerTypeAdapter.create(itemProperty);
        if (itemAdapter.getArrayItem() != null) {
            String protoName = this.generateWrapPropertyName(List.class.getSimpleName(), itemAdapter.getArrayItem());
            this.pending.add(() -> this.wrapPropertyToMessage(protoName, itemProperty));
            return protoName;
        }
        if (itemAdapter.getMapItem() != null) {
            String protoName = this.generateWrapPropertyName(Map.class.getSimpleName(), itemAdapter.getMapItem());
            this.pending.add(() -> this.wrapPropertyToMessage(protoName, itemProperty));
            return protoName;
        }
        return this.convertSwaggerType(itemProperty);
    }

    private String generateWrapPropertyName(String prefix, Schema property) {
        SwaggerTypeAdapter adapter = SwaggerTypeAdapter.create(property);
        if (adapter.getArrayItem() != null) {
            return this.generateWrapPropertyName(prefix + List.class.getSimpleName(), adapter.getArrayItem());
        }
        if (adapter.getMapItem() != null) {
            return this.generateWrapPropertyName(prefix + Map.class.getSimpleName(), adapter.getMapItem());
        }
        return prefix + StringUtils.capitalize((String)SwaggerToProtoGenerator.escapeMessageName(this.convertSwaggerType(adapter)));
    }

    private void wrapPropertyToMessage(String protoName, Schema property) {
        this.createMessage(protoName, Collections.singletonMap("value", property), "@WrapProperty");
    }

    private String tryFindEnumType(List<String> enums) {
        if (enums != null && !enums.isEmpty()) {
            String strEnums = enums.toString();
            String enumName = "Enum_" + Hashing.sha256().hashString((CharSequence)strEnums, StandardCharsets.UTF_8);
            this.pending.add(() -> this.createEnum(enumName, enums));
            return enumName;
        }
        return null;
    }

    private void createEnum(String enumName, List<String> enums) {
        if (!this.messages.add(enumName)) {
            return;
        }
        StringBuilderUtils.appendLine((StringBuilder)this.msgStringBuilder, (String)"enum %s {", (Object[])new Object[]{enumName});
        for (int idx = 0; idx < enums.size(); ++idx) {
            if (!SwaggerToProtoGenerator.isValidEnum(enums.get(idx))) {
                throw new IllegalStateException(String.format("enum class [%s] name [%s] not supported by protobuffer.", enumName, enums.get(idx)));
            }
            StringBuilderUtils.appendLine((StringBuilder)this.msgStringBuilder, (String)"  %s =%d;", (Object[])new Object[]{enums.get(idx), idx});
        }
        StringBuilderUtils.appendLine((StringBuilder)this.msgStringBuilder, (String)"}", (Object[])new Object[0]);
    }

    private String findBaseType(String swaggerType, String swaggerFmt) {
        String key;
        return switch (key = swaggerType + ":" + swaggerFmt) {
            case "boolean:null" -> "bool";
            case "integer:int32" -> "sint32";
            case "integer:int64" -> "sint64";
            case "integer:null" -> "string";
            case "number:double" -> "double";
            case "number:float" -> "float";
            case "number:null" -> "string";
            case "string:null" -> "string";
            case "string:byte" -> "bytes";
            case "string:date" -> "int64";
            case "string:date-time" -> "int64";
            case "string:binary" -> throw new IllegalArgumentException("proto buffer not support file upload/download");
            default -> null;
        };
    }

    private void convertOperations() {
        Paths paths = this.swagger.getPaths();
        if (paths == null || paths.isEmpty()) {
            return;
        }
        StringBuilderUtils.appendLine((StringBuilder)this.serviceBuilder, (String)"service MainService {", (Object[])new Object[0]);
        for (PathItem path : paths.values()) {
            for (Operation operation : path.readOperations()) {
                if (this.isUpload(operation)) {
                    LOGGER.warn("Not support operation for highway {}.{}, {}", new Object[]{this.protoPackage, operation.getOperationId(), "file upload not supported"});
                    continue;
                }
                if (this.isDownload(operation)) {
                    LOGGER.warn("Not support operation for highway {}.{}, {}", new Object[]{this.protoPackage, operation.getOperationId(), "file download not supported"});
                    continue;
                }
                try {
                    this.convertOperation(operation);
                }
                catch (Exception e) {
                    LOGGER.error("Not support operation for highway {}.{}", new Object[]{this.protoPackage, operation.getOperationId(), e});
                }
            }
        }
        this.serviceBuilder.setLength(this.serviceBuilder.length() - 1);
        StringBuilderUtils.appendLine((StringBuilder)this.serviceBuilder, (String)"}", (Object[])new Object[0]);
    }

    private boolean isUpload(Operation operation) {
        return operation.getRequestBody() != null && operation.getRequestBody().getContent() != null && operation.getRequestBody().getContent().get((Object)"multipart/form-data") != null;
    }

    private boolean isDownload(Operation operation) {
        return operation.getResponses().get((Object)SwaggerConst.SUCCESS_KEY) != null && ((ApiResponse)operation.getResponses().get((Object)SwaggerConst.SUCCESS_KEY)).getContent() != null && ((ApiResponse)operation.getResponses().get((Object)SwaggerConst.SUCCESS_KEY)).getContent().get((Object)"multipart/form-data") != null;
    }

    private void convertOperation(Operation operation) {
        ProtoMethod protoMethod = new ProtoMethod();
        this.fillRequestType(operation, protoMethod);
        this.fillResponseType(operation, protoMethod);
        StringBuilderUtils.appendLine((StringBuilder)this.serviceBuilder, (String)"  //%s%s", (Object[])new Object[]{ProtoConst.ANNOTATION_RPC, Json.encode((Object)protoMethod)});
        StringBuilderUtils.appendLine((StringBuilder)this.serviceBuilder, (String)"  rpc %s (%s) returns (%s);\n", (Object[])new Object[]{operation.getOperationId(), protoMethod.getArgTypeName(), protoMethod.findResponse(Response.Status.OK.getStatusCode()).getTypeName()});
    }

    private void fillRequestType(Operation operation, ProtoMethod protoMethod) {
        String type;
        int parametersCount = this.parametersCount(operation);
        if (parametersCount == 0) {
            this.addImports(ProtoConst.EMPTY_PROTO);
            protoMethod.setArgTypeName(ProtoConst.EMPTY.getCanonicalName());
            return;
        }
        if (parametersCount == 1 && this.messages.contains(type = this.convertSwaggerType(this.oneSchema(operation)))) {
            protoMethod.setArgTypeName(type);
            return;
        }
        String wrapName = StringUtils.capitalize((String)operation.getOperationId()) + "RequestWrap";
        this.createWrapArgs(wrapName, this.wrapSchema(operation));
        protoMethod.setArgTypeName(wrapName);
    }

    private Map<String, Schema> wrapSchema(Operation operation) {
        LinkedHashMap<String, Schema> properties = new LinkedHashMap<String, Schema>();
        if (operation.getParameters() != null) {
            for (Parameter parameter : operation.getParameters()) {
                properties.put(parameter.getName(), parameter.getSchema());
            }
        }
        if (operation.getRequestBody() != null && operation.getRequestBody().getContent().size() != 0) {
            if (operation.getRequestBody().getContent().get((Object)"application/x-www-form-urlencoded") != null) {
                ((MediaType)operation.getRequestBody().getContent().get((Object)"application/x-www-form-urlencoded")).getSchema().getProperties().forEach((k, v) -> properties.put((String)k, (Schema)v));
            } else {
                properties.put((String)operation.getRequestBody().getExtensions().get("x-name"), ((MediaType)operation.getRequestBody().getContent().get(operation.getRequestBody().getContent().keySet().iterator().next())).getSchema());
            }
        }
        return properties;
    }

    private Schema oneSchema(Operation operation) {
        if (operation.getParameters() != null && operation.getParameters().size() == 1) {
            return ((Parameter)operation.getParameters().get(0)).getSchema();
        }
        if (operation.getRequestBody().getContent().get((Object)"application/x-www-form-urlencoded") != null) {
            return (Schema)((MediaType)operation.getRequestBody().getContent().get((Object)"application/x-www-form-urlencoded")).getSchema().getProperties().values().iterator().next();
        }
        return ((MediaType)operation.getRequestBody().getContent().get(operation.getRequestBody().getContent().keySet().iterator().next())).getSchema();
    }

    private int parametersCount(Operation operation) {
        int parameters;
        int n = parameters = operation.getParameters() == null ? 0 : operation.getParameters().size();
        if (operation.getRequestBody() != null) {
            if (operation.getRequestBody().getContent().get((Object)"application/x-www-form-urlencoded") != null) {
                parameters += ((MediaType)operation.getRequestBody().getContent().get((Object)"application/x-www-form-urlencoded")).getSchema().getProperties().size();
            } else if (operation.getRequestBody().getContent().size() != 0) {
                ++parameters;
            }
        }
        return parameters;
    }

    private void fillResponseType(Operation operation, ProtoMethod protoMethod) {
        for (Map.Entry entry : operation.getResponses().entrySet()) {
            String type;
            Schema schema = null;
            if (((ApiResponse)entry.getValue()).getContent() != null && ((ApiResponse)entry.getValue()).getContent().size() != 0) {
                schema = ((MediaType)((ApiResponse)entry.getValue()).getContent().get(((ApiResponse)entry.getValue()).getContent().keySet().iterator().next())).getSchema();
            }
            boolean wrapped = !this.messages.contains(type = this.convertSwaggerType(schema));
            ProtoResponse protoResponse = new ProtoResponse();
            protoResponse.setTypeName(type);
            if (wrapped) {
                String wrapName = StringUtils.capitalize((String)operation.getOperationId()) + "ResponseWrap" + (String)entry.getKey();
                this.wrapPropertyToMessage(wrapName, schema);
                protoResponse.setTypeName(wrapName);
            }
            protoMethod.addResponse((String)entry.getKey(), protoResponse);
        }
    }

    private void createWrapArgs(String wrapName, Map<String, Schema> properties) {
        this.createMessage(wrapName, properties, "@WrapArguments");
    }

    protected Proto createProto() {
        StringBuilder sb = new StringBuilder();
        StringBuilderUtils.appendLine((StringBuilder)sb, (String)"syntax = \"proto3\";", (Object[])new Object[0]);
        for (String importMsg : this.imports) {
            StringBuilderUtils.appendLine((StringBuilder)sb, (String)"import \"%s\";", (Object[])new Object[]{importMsg});
        }
        if (StringUtils.isNotEmpty((CharSequence)this.protoPackage)) {
            sb.append("package ").append(this.protoPackage).append(";\n");
        }
        sb.append((CharSequence)this.msgStringBuilder);
        sb.append((CharSequence)this.serviceBuilder);
        ProtoParser protoParser = new ProtoParser();
        return protoParser.parseFromContent(sb.toString());
    }
}

