/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.huaweicloud.dashboard.monitor.data;

import org.springframework.core.env.Environment;

public class MonitorConstant {
    public static final String SYSTEM_KEY_DASHBOARD_SERVICE = "DashboardService";
    public static final String MONITOR_URI = "servicecomb.monitor.client.serverUri";
    public static final String PROXY_ENABLE = "servicecomb.proxy.enable";
    public static final String PROXY_HOST = "servicecomb.proxy.host";
    public static final String PROXY_PORT = "servicecomb.proxy.port";
    public static final String PROXY_USERNAME = "servicecomb.proxy.username";
    public static final String PROXY_PASSWD = "servicecomb.proxy.passwd";
    public static final int MIN_INTERVAL_MILLISECONDS = 5000;
    public static final int DEFAULT_TIMEOUT = 5000;
    public static final int DEFAULT_INTERVAL = 10000;
    private final String DOMAIN_NAME;
    private final String CURRENT_VERSION;
    private final String VERSION_V1;
    private final String PREFIX_V2;
    private final String monitorsUri;
    private Environment environment;

    public MonitorConstant(Environment environment) {
        this.environment = environment;
        this.VERSION_V1 = "v1";
        this.DOMAIN_NAME = this.getDomainName();
        this.PREFIX_V2 = String.format("/v2/%s/csemonitor", this.DOMAIN_NAME);
        this.CURRENT_VERSION = this.getApiVersion();
        this.monitorsUri = this.VERSION_V1.equals(this.CURRENT_VERSION) ? "/csemonitor/v1/metric?service=%s" : this.PREFIX_V2 + "/metric?service=%s";
    }

    public String getMonitorUri() {
        return this.monitorsUri;
    }

    public String getDomainName() {
        return this.environment.getProperty("servicecomb.config.client.domainName", "default");
    }

    public String getApiVersion() {
        return this.environment.getProperty("servicecomb.monitor.client.api.version", "v2");
    }

    public String getServerUrl() {
        return this.environment.getProperty(MONITOR_URI);
    }

    public boolean sslEnabled() {
        return (Boolean)this.environment.getProperty("servicecomb.monitor.client.sslEnabled", Boolean.TYPE, (Object)true);
    }

    public boolean isMonitorEnabled() {
        return (Boolean)this.environment.getProperty("servicecomb.monitor.client.enabled", Boolean.TYPE, (Object)false);
    }

    public int getConnectionTimeout() {
        return (Integer)this.environment.getProperty("servicecomb.monitor.client.timeout", Integer.TYPE, (Object)5000);
    }

    public int getInterval() {
        return Math.max((Integer)this.environment.getProperty("servicecomb.monitor.client.interval", Integer.TYPE, (Object)10000), 5000);
    }

    public Boolean isProxyEnable() {
        return Boolean.parseBoolean(this.getProperty("false", PROXY_ENABLE));
    }

    public String getProxyHost() {
        return this.getProperty("127.0.0.1", PROXY_HOST);
    }

    public int getProxyPort() {
        return Integer.parseInt(this.getProperty("8080", PROXY_PORT));
    }

    public String getProxyUsername() {
        return this.getProperty(null, PROXY_USERNAME);
    }

    public String getProxyPasswd() {
        return this.getProperty(null, PROXY_PASSWD);
    }

    private String getProperty(String defaultValue, String ... keys) {
        String key;
        String property = null;
        String[] stringArray = keys;
        int n = stringArray.length;
        for (int i = 0; i < n && (property = this.environment.getProperty(key = stringArray[i])) == null; ++i) {
        }
        if (property != null) {
            return property;
        }
        return defaultValue;
    }
}

