/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.governance.handler;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.micrometer.tagged.CircuitBreakerMetricNames;
import io.github.resilience4j.micrometer.tagged.TaggedCircuitBreakerMetrics;
import java.time.Duration;
import org.apache.servicecomb.governance.handler.AbstractGovernanceHandler;
import org.apache.servicecomb.governance.handler.Disposable;
import org.apache.servicecomb.governance.handler.DisposableCircuitBreaker;
import org.apache.servicecomb.governance.handler.ext.AbstractCircuitBreakerExtension;
import org.apache.servicecomb.governance.marker.GovernanceRequestExtractor;
import org.apache.servicecomb.governance.policy.CircuitBreakerPolicy;
import org.apache.servicecomb.governance.properties.CircuitBreakerProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CircuitBreakerHandler
extends AbstractGovernanceHandler<CircuitBreaker, CircuitBreakerPolicy> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CircuitBreakerHandler.class);
    private final CircuitBreakerProperties circuitBreakerProperties;
    private final AbstractCircuitBreakerExtension circuitBreakerExtension;

    public CircuitBreakerHandler(CircuitBreakerProperties circuitBreakerProperties, AbstractCircuitBreakerExtension circuitBreakerExtension) {
        this.circuitBreakerProperties = circuitBreakerProperties;
        this.circuitBreakerExtension = circuitBreakerExtension;
    }

    @Override
    protected String createKey(GovernanceRequestExtractor requestExtractor, CircuitBreakerPolicy policy) {
        return this.circuitBreakerProperties.getConfigKey() + "." + policy.getName();
    }

    @Override
    public CircuitBreakerPolicy matchPolicy(GovernanceRequestExtractor requestExtractor) {
        return (CircuitBreakerPolicy)this.matchersManager.match(requestExtractor, this.circuitBreakerProperties.getParsedEntity());
    }

    @Override
    public Disposable<CircuitBreaker> createProcessor(String key, GovernanceRequestExtractor requestExtractor, CircuitBreakerPolicy policy) {
        return this.getCircuitBreaker(key, policy);
    }

    private Disposable<CircuitBreaker> getCircuitBreaker(String key, CircuitBreakerPolicy policy) {
        LOGGER.info("applying new policy {} for {}", (Object)key, (Object)policy);
        CircuitBreakerConfig circuitBreakerConfig = CircuitBreakerConfig.custom().failureRateThreshold(policy.getFailureRateThreshold()).slowCallRateThreshold(policy.getSlowCallRateThreshold()).waitDurationInOpenState(Duration.parse(policy.getWaitDurationInOpenState())).slowCallDurationThreshold(Duration.parse(policy.getSlowCallDurationThreshold())).permittedNumberOfCallsInHalfOpenState(policy.getPermittedNumberOfCallsInHalfOpenState()).minimumNumberOfCalls(policy.getMinimumNumberOfCalls()).slidingWindowType(policy.getSlidingWindowTypeEnum()).slidingWindowSize(Integer.parseInt(policy.getSlidingWindowSize())).recordException(e -> this.circuitBreakerExtension.isFailedResult(policy.getRecordFailureStatus(), (Throwable)e)).recordResult(r -> this.circuitBreakerExtension.isFailedResult(policy.getRecordFailureStatus(), r)).build();
        CircuitBreakerRegistry circuitBreakerRegistry = CircuitBreakerRegistry.of((CircuitBreakerConfig)circuitBreakerConfig);
        if (this.meterRegistry != null) {
            TaggedCircuitBreakerMetrics.ofCircuitBreakerRegistry((CircuitBreakerMetricNames)CircuitBreakerMetricNames.custom().callsMetricName(this.circuitBreakerProperties.getConfigKey() + ".calls").notPermittedCallsMetricName(this.circuitBreakerProperties.getConfigKey() + ".not.permitted.calls").stateMetricName(this.circuitBreakerProperties.getConfigKey() + ".state").bufferedCallsMetricName(this.circuitBreakerProperties.getConfigKey() + ".buffered.calls").slowCallsMetricName(this.circuitBreakerProperties.getConfigKey() + ".slow.calls").failureRateMetricName(this.circuitBreakerProperties.getConfigKey() + ".failure.rate").slowCallRateMetricName(this.circuitBreakerProperties.getConfigKey() + ".slow.call.rate").build(), (CircuitBreakerRegistry)circuitBreakerRegistry).bindTo(this.meterRegistry);
        }
        return new DisposableCircuitBreaker(key, circuitBreakerRegistry, circuitBreakerRegistry.circuitBreaker(key, circuitBreakerConfig));
    }
}

