/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.lightweight;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.concurrent.CompletableFuture;
import org.apache.servicecomb.provider.rest.common.RestSchema;
import org.apache.servicecomb.registry.lightweight.MicroserviceInfo;
import org.apache.servicecomb.registry.lightweight.Self;
import org.apache.servicecomb.registry.lightweight.model.Microservice;
import org.apache.servicecomb.registry.lightweight.model.MicroserviceInstance;

@RestSchema(schemaId="scb-discovery")
@Path(value="/v1/discovery")
public class DiscoveryEndpoint {
    public static final String SCHEMA_ID = "scb-discovery";
    private final Self self;

    public DiscoveryEndpoint(Self self) {
        this.self = self;
    }

    @Parameters(value={@Parameter(name="service-id", in=ParameterIn.QUERY, schema=@Schema(implementation=String.class), description="just make it possible to mock many instances by one real instance for performance test")})
    @Path(value="/info")
    @GET
    public CompletableFuture<MicroserviceInfo> getInfo() {
        return CompletableFuture.completedFuture(this.self.getMicroserviceInfo());
    }

    @Parameters(value={@Parameter(name="service-id", in=ParameterIn.QUERY, schema=@Schema(implementation=String.class), description="just make it possible to mock many instances by one real instance for performance test")})
    @Path(value="/microservice")
    @GET
    public CompletableFuture<Microservice> getMicroservice() {
        return CompletableFuture.completedFuture(this.self.getMicroservice());
    }

    @Parameters(value={@Parameter(name="service-id", in=ParameterIn.QUERY, schema=@Schema(implementation=String.class), description="just make it possible to mock many instances by one real instance for performance test")})
    @Path(value="/instance")
    @GET
    public CompletableFuture<MicroserviceInstance> getInstance() {
        return CompletableFuture.completedFuture(this.self.getInstance());
    }

    @Parameters(value={@Parameter(name="service-id", in=ParameterIn.QUERY, schema=@Schema(implementation=String.class), description="just make it possible to mock many instances by one real instance for performance test")})
    @Path(value="/schemas/{schema-id}")
    @GET
    @Produces(value={"text/plain"})
    public CompletableFuture<String> getSchema(@PathParam(value="schema-id") String schemaId) {
        return CompletableFuture.completedFuture(this.self.getMicroservice().getSchemaMap().get(schemaId));
    }
}

