/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.provider.pojo;

import java.lang.reflect.Method;
import java.util.concurrent.CompletableFuture;
import org.apache.servicecomb.provider.pojo.PojoConsumerMetaRefresher;
import org.apache.servicecomb.provider.pojo.PojoInvocation;
import org.apache.servicecomb.provider.pojo.definition.PojoConsumerMeta;
import org.apache.servicecomb.provider.pojo.definition.PojoConsumerOperationMeta;

public class PojoInvocationCreator {
    public PojoInvocation create(Method method, PojoConsumerMetaRefresher metaRefresher, Object[] args) {
        long startCreateInvocation = System.nanoTime();
        PojoConsumerMeta pojoConsumerMeta = metaRefresher.getLatestMeta();
        PojoConsumerOperationMeta consumerOperationMeta = pojoConsumerMeta.ensureFindOperationMeta(method);
        PojoInvocation invocation = new PojoInvocation(consumerOperationMeta);
        invocation.setSuccessResponseType(consumerOperationMeta.getResponsesType());
        invocation.setInvocationArguments(consumerOperationMeta.getSwaggerConsumerOperation().toInvocationArguments(args));
        invocation.setSync(consumerOperationMeta.isSync());
        invocation.getInvocationStageTrace().startCreateInvocation(startCreateInvocation);
        invocation.getInvocationStageTrace().finishCreateInvocation();
        return invocation;
    }

    public CompletableFuture<PojoInvocation> createAsync(Method method, PojoConsumerMetaRefresher metaRefresher, Object[] args) {
        CompletableFuture<PojoConsumerMeta> pojoConsumerMetaFuture = metaRefresher.getLatestMetaAsync();
        return pojoConsumerMetaFuture.thenCompose(pojoConsumerMeta -> {
            PojoConsumerOperationMeta consumerOperationMeta = pojoConsumerMeta.ensureFindOperationMeta(method);
            PojoInvocation invocation = new PojoInvocation(consumerOperationMeta);
            invocation.setSuccessResponseType(consumerOperationMeta.getResponsesType());
            invocation.setInvocationArguments(consumerOperationMeta.getSwaggerConsumerOperation().toInvocationArguments(args));
            invocation.setSync(consumerOperationMeta.isSync());
            return CompletableFuture.completedFuture(invocation);
        });
    }
}

