/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.core.model;

import io.swagger.v3.oas.annotations.enums.ParameterIn;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public enum HttpParameterType {
    PATH,
    QUERY,
    HEADER,
    COOKIE,
    FORM,
    BODY;


    public static HttpParameterType from(ParameterIn in) {
        return switch (in) {
            case ParameterIn.COOKIE -> COOKIE;
            case ParameterIn.QUERY -> QUERY;
            case ParameterIn.HEADER -> HEADER;
            case ParameterIn.PATH -> PATH;
            default -> null;
        };
    }

    public static HttpParameterType parse(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        return HttpParameterType.valueOf(value.toUpperCase(Locale.US));
    }

    public static boolean isBodyParameter(HttpParameterType type) {
        return BODY == type || FORM == type;
    }
}

