/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.apollo;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.servicecomb.config.ConfigMapping;
import org.apache.servicecomb.config.DynamicPropertiesSource;
import org.apache.servicecomb.config.apollo.ApolloClient;
import org.apache.servicecomb.config.apollo.ApolloConfig;
import org.apache.servicecomb.config.apollo.ConfigurationAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class ApolloDynamicPropertiesSource
implements DynamicPropertiesSource {
    public static final String SOURCE_NAME = "apollo";
    private static final Logger LOGGER = LoggerFactory.getLogger(ApolloDynamicPropertiesSource.class);
    private final Map<String, Object> valueCache = new ConcurrentHashMap<String, Object>();
    private final UpdateHandler updateHandler = new UpdateHandler();

    public int getOrder() {
        return 300;
    }

    private void init(Environment environment) {
        ApolloConfig apolloConfig = new ApolloConfig(environment);
        ApolloClient apolloClient = new ApolloClient(this.updateHandler, apolloConfig);
        apolloClient.refreshApolloConfig();
    }

    public PropertySource<?> create(Environment environment) {
        this.init(environment);
        return new MapPropertySource(SOURCE_NAME, this.valueCache);
    }

    public class UpdateHandler {
        public void handle(ConfigurationAction action, Map<String, Object> config) {
            if (config == null || config.isEmpty()) {
                return;
            }
            Map configuration = ConfigMapping.getConvertedMap(config);
            if (ConfigurationAction.CREATE.equals((Object)action)) {
                ApolloDynamicPropertiesSource.this.valueCache.putAll(configuration);
            } else if (ConfigurationAction.SET.equals((Object)action)) {
                ApolloDynamicPropertiesSource.this.valueCache.putAll(configuration);
            } else if (ConfigurationAction.DELETE.equals((Object)action)) {
                configuration.keySet().forEach(ApolloDynamicPropertiesSource.this.valueCache::remove);
            } else {
                LOGGER.error("action: {} is invalid.", (Object)action.name());
                return;
            }
            LOGGER.warn("Config value cache changed: action:{}; item:{}", (Object)action.name(), configuration.keySet());
        }
    }
}

