/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core.meter.pool;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.servicecomb.core.executor.ThreadPoolExecutorEx;
import org.apache.servicecomb.foundation.metrics.meter.PeriodMeter;

public class ThreadPoolMeter
implements PeriodMeter {
    public static final String THREAD_POOL_METER = "servicecomb.threadpool";
    public static final String ID = "id";
    public static final String STAGE = "stage";
    public static final String REJECTED_COUNT = "rejectedCount";
    public static final String TASK_COUNT = "taskCount";
    public static final String COMPLETED_TASK_COUNT = "completedTaskCount";
    public static final String CURRENT_THREADS_BUSY = "currentThreadsBusy";
    public static final String MAX_THREADS = "maxThreads";
    public static final String POOL_SIZE = "poolSize";
    public static final String CORE_POOL_SIZE = "corePoolSize";
    public static final String QUEUE_SIZE = "queueSize";
    private final ThreadPoolExecutor threadPoolExecutor;
    private long currentTask;
    private long lastTask;
    private long currentCompletedTask;
    private long lastCompletedTask;

    public ThreadPoolMeter(MeterRegistry meterRegistry, String threadPoolName, ThreadPoolExecutor threadPoolExecutor) {
        this.threadPoolExecutor = threadPoolExecutor;
        Gauge.builder((String)THREAD_POOL_METER, () -> this.currentTask).tags(new String[]{ID, threadPoolName, STAGE, TASK_COUNT}).register(meterRegistry);
        Gauge.builder((String)THREAD_POOL_METER, () -> this.currentCompletedTask).tags(new String[]{ID, threadPoolName, STAGE, COMPLETED_TASK_COUNT}).register(meterRegistry);
        Gauge.builder((String)THREAD_POOL_METER, threadPoolExecutor::getActiveCount).tags(new String[]{ID, threadPoolName, STAGE, CURRENT_THREADS_BUSY}).register(meterRegistry);
        Gauge.builder((String)THREAD_POOL_METER, threadPoolExecutor::getMaximumPoolSize).tags(new String[]{ID, threadPoolName, STAGE, MAX_THREADS}).register(meterRegistry);
        Gauge.builder((String)THREAD_POOL_METER, threadPoolExecutor::getPoolSize).tags(new String[]{ID, threadPoolName, STAGE, POOL_SIZE}).register(meterRegistry);
        Gauge.builder((String)THREAD_POOL_METER, threadPoolExecutor::getCorePoolSize).tags(new String[]{ID, threadPoolName, STAGE, CORE_POOL_SIZE}).register(meterRegistry);
        Gauge.builder((String)THREAD_POOL_METER, () -> threadPoolExecutor.getQueue().size()).tags(new String[]{ID, threadPoolName, STAGE, QUEUE_SIZE}).register(meterRegistry);
        if (threadPoolExecutor instanceof ThreadPoolExecutorEx) {
            Gauge.builder((String)THREAD_POOL_METER, () -> ((ThreadPoolExecutorEx)threadPoolExecutor).getRejectedCount()).tags(new String[]{ID, threadPoolName, STAGE, REJECTED_COUNT}).register(meterRegistry);
        }
    }

    public void poll(long msNow, long secondInterval) {
        long temp = this.threadPoolExecutor.getTaskCount();
        this.currentTask = temp - this.lastTask;
        this.lastTask = temp;
        temp = this.threadPoolExecutor.getCompletedTaskCount();
        this.currentCompletedTask = temp - this.lastCompletedTask;
        this.lastCompletedTask = temp;
    }
}

