/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.controller;

import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.aspect.annotation.RestApi;
import org.apache.shenyu.admin.controller.PagedController;
import org.apache.shenyu.admin.mapper.PluginMapper;
import org.apache.shenyu.admin.model.dto.BatchCommonDTO;
import org.apache.shenyu.admin.model.dto.PluginDTO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageParameter;
import org.apache.shenyu.admin.model.query.PluginQuery;
import org.apache.shenyu.admin.model.query.PluginQueryCondition;
import org.apache.shenyu.admin.model.result.ShenyuAdminResult;
import org.apache.shenyu.admin.model.vo.PluginVO;
import org.apache.shenyu.admin.service.PageService;
import org.apache.shenyu.admin.service.PluginService;
import org.apache.shenyu.admin.validation.annotation.Existed;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

@RestApi(value={"/plugin-template"})
public class PluginController
implements PagedController<PluginQueryCondition, PluginVO> {
    private final PluginService pluginService;

    public PluginController(PluginService pluginService) {
        this.pluginService = pluginService;
    }

    @GetMapping
    public ShenyuAdminResult queryPlugins(String name, Integer enabled, @NotNull Integer currentPage, @NotNull Integer pageSize) {
        CommonPager<PluginVO> commonPager = this.pluginService.listByPage(new PluginQuery(name, enabled, new PageParameter(currentPage, pageSize)));
        return ShenyuAdminResult.success("query success", commonPager);
    }

    @GetMapping(value={"/all"})
    public ShenyuAdminResult queryAllPlugins() {
        List<PluginData> pluginDataList = this.pluginService.listAll();
        return ShenyuAdminResult.success("query success", pluginDataList);
    }

    @GetMapping(value={"/{id}"})
    @RequiresPermissions(value={"system:plugin:edit"})
    public ShenyuAdminResult detailPlugin(@PathVariable(value="id") @Existed(message="plugin is not existed", provider=PluginMapper.class) @Existed(message="plugin is not existed", provider=PluginMapper.class) String id) {
        PluginVO pluginVO = this.pluginService.findById(id);
        return ShenyuAdminResult.success("detail success", pluginVO);
    }

    @PostMapping
    @RequiresPermissions(value={"system:plugin:add"})
    public ShenyuAdminResult createPlugin(@Valid @ModelAttribute PluginDTO pluginDTO) {
        return ShenyuAdminResult.success(this.pluginService.createOrUpdate(pluginDTO));
    }

    @PutMapping(value={"/{id}"})
    @RequiresPermissions(value={"system:plugin:edit"})
    public ShenyuAdminResult updatePlugin(@PathVariable(value="id") @Existed(message="plugin is not existed", provider=PluginMapper.class) @Existed(message="plugin is not existed", provider=PluginMapper.class) String id, @Valid @ModelAttribute PluginDTO pluginDTO) {
        pluginDTO.setId(id);
        return this.createPlugin(pluginDTO);
    }

    @PutMapping(value={"/createPluginResource/{id}"})
    @RequiresPermissions(value={"system:plugin:resource"})
    public ShenyuAdminResult createPluginResource(@PathVariable(value="id") @Existed(message="plugin is not existed", provider=PluginMapper.class) @Existed(message="plugin is not existed", provider=PluginMapper.class) String id, @Valid @RequestBody PluginDTO pluginDTO) {
        pluginDTO.setId(id);
        return ShenyuAdminResult.success(this.pluginService.createPluginResource(pluginDTO));
    }

    @DeleteMapping(value={"/batch"})
    @RequiresPermissions(value={"system:plugin:delete"})
    public ShenyuAdminResult deletePlugins(@RequestBody @NotEmpty List<@NotBlank String> ids) {
        String result = this.pluginService.delete(ids);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{result})) {
            return ShenyuAdminResult.error(result);
        }
        return ShenyuAdminResult.success("delete success");
    }

    @PostMapping(value={"/enabled"})
    @RequiresPermissions(value={"system:plugin:disable"})
    public ShenyuAdminResult enabled(@Valid @RequestBody BatchCommonDTO batchCommonDTO) {
        String result = this.pluginService.enabled(batchCommonDTO.getIds(), batchCommonDTO.getEnabled());
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{result})) {
            return ShenyuAdminResult.error(result);
        }
        return ShenyuAdminResult.success("enable success");
    }

    @GetMapping(value={"/snapshot/active"})
    public ShenyuAdminResult activePluginSnapshot() {
        return ShenyuAdminResult.success(this.pluginService.activePluginSnapshot());
    }

    @Override
    public PageService<PluginQueryCondition, PluginVO> pageService() {
        return this.pluginService;
    }
}

