/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.entity;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.dto.ScalePolicyDTO;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.common.utils.DateUtils;
import org.apache.shenyu.common.utils.UUIDUtils;

public final class ScalePolicyDO
extends BaseDO {
    private static final long serialVersionUID = -6895279885108899135L;
    private Integer sort;
    private Integer status;
    private Integer num;
    private Date beginTime;
    private Date endTime;
    private Date dateCreated;
    private Date dateUpdated;

    public ScalePolicyDO() {
    }

    public ScalePolicyDO(Integer sort, Integer status, Integer num, Date beginTime, Date endTime) {
        this.sort = sort;
        this.status = status;
        this.num = num;
        this.beginTime = beginTime;
        this.endTime = endTime;
    }

    public Integer getSort() {
        return this.sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getNum() {
        return this.num;
    }

    public void setNum(Integer num) {
        this.num = num;
    }

    public Date getBeginTime() {
        return this.beginTime;
    }

    public void setBeginTime(Date beginTime) {
        this.beginTime = beginTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (Objects.isNull(o) || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ScalePolicyDO that = (ScalePolicyDO)o;
        return Objects.equals(this.sort, that.sort) && Objects.equals(this.status, that.status) && Objects.equals(this.num, that.num) && Objects.equals(this.beginTime, that.beginTime) && Objects.equals(this.endTime, that.endTime);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.sort, this.status, this.num, this.beginTime, this.endTime);
    }

    public static ScalePolicyDOBuilder builder() {
        return new ScalePolicyDOBuilder();
    }

    public static ScalePolicyDO buildScalePolicyDO(ScalePolicyDTO scalePolicyDTO) {
        return Optional.ofNullable(scalePolicyDTO).map(item -> {
            Timestamp currentTime = new Timestamp(System.currentTimeMillis());
            try {
                ScalePolicyDO scalePolicyDO = ScalePolicyDO.builder().sort(item.getSort()).status(item.getStatus()).num(item.getNum()).beginTime(Objects.nonNull(item.getBeginTime()) && DateUtils.isValidDate((String)DateUtils.localDateTimeToString((LocalDateTime)item.getBeginTime())) ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(DateUtils.localDateTimeToString((LocalDateTime)item.getBeginTime())) : null).endTime(Objects.nonNull(item.getEndTime()) && DateUtils.isValidDate((String)DateUtils.localDateTimeToString((LocalDateTime)item.getEndTime())) ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(DateUtils.localDateTimeToString((LocalDateTime)item.getEndTime())) : null).dateUpdated(currentTime).build();
                if (StringUtils.isEmpty((CharSequence)item.getId())) {
                    scalePolicyDO.setId(UUIDUtils.getInstance().generateShortUuid());
                    scalePolicyDO.setDateCreated(currentTime);
                } else {
                    scalePolicyDO.setId(item.getId());
                }
                return scalePolicyDO;
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }).orElse(null);
    }

    public static final class ScalePolicyDOBuilder {
        private String id;
        private Integer sort;
        private Integer status;
        private Integer num;
        private Date beginTime;
        private Date endTime;
        private Timestamp dateCreated;
        private Timestamp dateUpdated;

        private ScalePolicyDOBuilder() {
        }

        public ScalePolicyDOBuilder id(String id) {
            this.id = id;
            return this;
        }

        public ScalePolicyDOBuilder sort(Integer sort) {
            this.sort = sort;
            return this;
        }

        public ScalePolicyDOBuilder status(Integer status) {
            this.status = status;
            return this;
        }

        public ScalePolicyDOBuilder num(Integer num) {
            this.num = num;
            return this;
        }

        public ScalePolicyDOBuilder beginTime(Date beginTime) {
            this.beginTime = beginTime;
            return this;
        }

        public ScalePolicyDOBuilder endTime(Date endTime) {
            this.endTime = endTime;
            return this;
        }

        public ScalePolicyDOBuilder dateCreated(Timestamp dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public ScalePolicyDOBuilder dateUpdated(Timestamp dateUpdated) {
            this.dateUpdated = dateUpdated;
            return this;
        }

        public ScalePolicyDO build() {
            ScalePolicyDO scalePolicyDO = new ScalePolicyDO();
            scalePolicyDO.setId(this.id);
            scalePolicyDO.setSort(this.sort);
            scalePolicyDO.setStatus(this.status);
            scalePolicyDO.setNum(this.num);
            scalePolicyDO.setBeginTime(this.beginTime);
            scalePolicyDO.setEndTime(this.endTime);
            scalePolicyDO.setDateCreated(this.dateCreated);
            scalePolicyDO.setDateUpdated(this.dateUpdated);
            return scalePolicyDO;
        }
    }
}

