/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import java.io.Serializable;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.aspect.annotation.Pageable;
import org.apache.shenyu.admin.mapper.NamespacePluginRelMapper;
import org.apache.shenyu.admin.mapper.PluginMapper;
import org.apache.shenyu.admin.model.dto.PluginDTO;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.admin.model.entity.PluginDO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageResultUtils;
import org.apache.shenyu.admin.model.query.PluginQuery;
import org.apache.shenyu.admin.model.query.PluginQueryCondition;
import org.apache.shenyu.admin.model.result.ConfigImportResult;
import org.apache.shenyu.admin.model.vo.PluginSnapshotVO;
import org.apache.shenyu.admin.model.vo.PluginVO;
import org.apache.shenyu.admin.service.PluginService;
import org.apache.shenyu.admin.service.configs.ConfigsImportContext;
import org.apache.shenyu.admin.service.publish.PluginEventPublisher;
import org.apache.shenyu.admin.transfer.PluginTransfer;
import org.apache.shenyu.admin.utils.Assert;
import org.apache.shenyu.admin.utils.SessionUtil;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.JarDependencyUtils;
import org.apache.shenyu.common.utils.ListUtil;
import org.apache.shenyu.common.utils.LogUtils;
import org.apache.shenyu.common.utils.UUIDUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PluginServiceImpl
implements PluginService {
    private static final Logger LOG = LoggerFactory.getLogger(PluginServiceImpl.class);
    private final PluginMapper pluginMapper;
    private final PluginEventPublisher pluginEventPublisher;
    private final NamespacePluginRelMapper namespacePluginRelMapper;

    public PluginServiceImpl(PluginMapper pluginMapper, PluginEventPublisher pluginEventPublisher, NamespacePluginRelMapper namespacePluginRelMapper) {
        this.pluginMapper = pluginMapper;
        this.pluginEventPublisher = pluginEventPublisher;
        this.namespacePluginRelMapper = namespacePluginRelMapper;
    }

    @Override
    public List<PluginVO> searchByCondition(PluginQueryCondition condition) {
        condition.init();
        return this.pluginMapper.searchByCondition(condition);
    }

    @Override
    public String createOrUpdate(PluginDTO pluginDTO) {
        return StringUtils.isBlank((CharSequence)pluginDTO.getId()) ? this.create(pluginDTO) : this.update(pluginDTO);
    }

    @Override
    public String createPluginResource(PluginDTO pluginDTO) {
        this.pluginEventPublisher.onCreated(PluginDO.buildPluginDO(pluginDTO));
        return "create success";
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String delete(List<String> ids) {
        List<PluginDO> plugins = this.pluginMapper.selectByIds(ids);
        if (CollectionUtils.isEmpty(plugins)) {
            return "The plugin(s) does not exist\uff01";
        }
        Optional<PluginDO> exist = plugins.stream().filter(value -> Objects.nonNull(this.namespacePluginRelMapper.selectByPluginId(value.getId()))).findAny();
        if (exist.isPresent()) {
            return "The plugin that exists under a certain namespace cannot be deleted.";
        }
        if (this.pluginMapper.deleteByIds(ListUtil.map(plugins, BaseDO::getId)) > 0) {
            this.pluginEventPublisher.onDeleted((Collection<PluginDO>)plugins);
        }
        return "";
    }

    @Override
    public String enabled(List<String> ids, Boolean enabled) {
        List<PluginDO> plugins = this.pluginMapper.selectByIds(ids);
        if (CollectionUtils.isEmpty(plugins)) {
            return "The plugin(s) does not exist\uff01";
        }
        plugins.forEach(pluginDO -> pluginDO.setEnabled(enabled));
        this.pluginMapper.updateEnableByIdList(ids, enabled);
        if (CollectionUtils.isNotEmpty(plugins)) {
            this.pluginEventPublisher.onEnabled(plugins);
        }
        return "";
    }

    @Override
    public PluginVO findById(String id) {
        return PluginVO.buildPluginVO(this.pluginMapper.selectById(id));
    }

    @Override
    @Pageable
    public CommonPager<PluginVO> listByPage(PluginQuery pluginQuery) {
        return PageResultUtils.result(pluginQuery.getPageParameter(), () -> this.pluginMapper.selectByQuery(pluginQuery).stream().map(PluginVO::buildPluginVO).collect(Collectors.toList()));
    }

    @Override
    public List<PluginData> listAll() {
        return ListUtil.map(this.pluginMapper.selectAll(), PluginTransfer.INSTANCE::mapToData);
    }

    @Override
    public List<PluginVO> listAllData() {
        return this.pluginMapper.selectAll().stream().filter(Objects::nonNull).map(PluginVO::buildPluginVO).collect(Collectors.toList());
    }

    @Override
    public List<PluginData> listAllNotInResource() {
        return ListUtil.map(this.pluginMapper.listAllNotInResource(), PluginTransfer.INSTANCE::mapToData);
    }

    @Override
    public String selectIdByName(String name) {
        PluginDO pluginDO = this.pluginMapper.selectByName(name);
        Objects.requireNonNull(pluginDO);
        return pluginDO.getId();
    }

    @Override
    public PluginDO findByName(String name) {
        return this.pluginMapper.selectByName(name);
    }

    @Override
    public List<PluginSnapshotVO> activePluginSnapshot() {
        return this.pluginMapper.activePluginSnapshot(SessionUtil.isAdmin() ? null : SessionUtil.visitor().getUserId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ConfigImportResult importData(List<PluginDTO> pluginList, ConfigsImportContext context) {
        if (CollectionUtils.isEmpty(pluginList)) {
            return ConfigImportResult.success();
        }
        Map<String, PluginDO> existPluginMap = this.pluginMapper.selectAll().stream().filter(Objects::nonNull).collect(Collectors.toMap(PluginDO::getName, x -> x));
        StringBuilder errorMsgBuilder = new StringBuilder();
        int successCount = 0;
        for (PluginDTO pluginDTO : pluginList) {
            String pluginName = pluginDTO.getName();
            if (existPluginMap.containsKey(pluginName)) {
                errorMsgBuilder.append(pluginName).append(",");
                Optional.ofNullable(context).ifPresent(c -> c.getPluginTemplateIdMapping().put(pluginDTO.getId(), ((PluginDO)existPluginMap.get(pluginName)).getId()));
                continue;
            }
            String pluginId = UUIDUtils.getInstance().generateShortUuid();
            Optional.ofNullable(context).ifPresent(c -> c.getPluginTemplateIdMapping().put(pluginDTO.getId(), pluginId));
            pluginDTO.setId(pluginId);
            PluginDO pluginDO = PluginDO.buildPluginDO(pluginDTO);
            if (this.pluginMapper.insertSelective(pluginDO) <= 0) continue;
            ++successCount;
        }
        if (StringUtils.isNotEmpty((CharSequence)errorMsgBuilder)) {
            errorMsgBuilder.setLength(errorMsgBuilder.length() - 1);
            return ConfigImportResult.fail(successCount, "import fail plugin: " + errorMsgBuilder);
        }
        return ConfigImportResult.success(successCount);
    }

    private String create(PluginDTO pluginDTO) {
        PluginDO pluginDO;
        Assert.isNull(this.pluginMapper.nameExisted((Serializable)((Object)pluginDTO.getName())), "createThe plugin name already exists and can't be added repeatedly!" + pluginDTO.getName());
        if (Objects.nonNull(pluginDTO.getFile())) {
            Assert.isTrue(this.checkFile(Base64.getDecoder().decode(pluginDTO.getFile())), "The plugin JAR file is not correct or exceeds 16MB!");
        }
        if (this.pluginMapper.insertSelective(pluginDO = PluginDO.buildPluginDO(pluginDTO)) > 0) {
            this.pluginEventPublisher.onCreated(pluginDO);
        }
        return "create success";
    }

    private String update(PluginDTO pluginDTO) {
        Assert.isNull(this.pluginMapper.nameExistedExclude((Serializable)((Object)pluginDTO.getName()), Collections.singletonList(pluginDTO.getId())), "The plugin name already exists and can't be added repeatedly!" + pluginDTO.getName());
        if (Objects.nonNull(pluginDTO.getFile())) {
            Assert.isTrue(this.checkFile(Base64.getDecoder().decode(pluginDTO.getFile())), "The plugin JAR file is not correct or exceeds 16MB!");
        }
        PluginDO before = this.pluginMapper.selectById(pluginDTO.getId());
        PluginDO pluginDO = PluginDO.buildPluginDO(pluginDTO);
        if (this.pluginMapper.updateSelective(pluginDO) > 0) {
            this.pluginEventPublisher.onUpdated(pluginDO, before);
        }
        return "update success";
    }

    private boolean checkFile(byte[] file) {
        try {
            if (file.length > 0x1000000) {
                LogUtils.warn((Logger)LOG, (String)"File size is {}MB larger than 16MB", (Object[])new Object[]{file.length / 0x100000});
                return false;
            }
            Set dependencyTree = JarDependencyUtils.getDependencyTree((byte[])file);
            return dependencyTree.contains("org.apache.shenyu.plugin.base.AbstractShenyuPlugin") || dependencyTree.contains("org.apache.shenyu.plugin.api.ShenyuPlugin") || dependencyTree.contains("org.apache.shenyu.plugin.logging.common.AbstractLoggingPlugin");
        }
        catch (Exception e) {
            LogUtils.error((Logger)LOG, (String)"check plugin jar error:{}", (Object[])new Object[]{e.getMessage()});
            throw new ShenyuException((Throwable)e);
        }
    }
}

