/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.register;

import jakarta.annotation.Resource;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import org.apache.shenyu.admin.service.register.AbstractShenyuClientRegisterServiceImpl;
import org.apache.shenyu.common.dto.convert.rule.impl.ContextMappingRuleHandle;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.PathUtils;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.integration.support.locks.LockRegistry;

public abstract class AbstractContextPathRegisterService
extends AbstractShenyuClientRegisterServiceImpl {
    private static final String LOCK_KEY_PREFIX = "context-path:";
    private final Logger logger = LoggerFactory.getLogger(AbstractContextPathRegisterService.class);
    @Resource
    private LockRegistry registry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerContextPath(MetaDataRegisterDTO dto) {
        this.checkNamespacePluginRel(dto.getNamespaceId(), PluginEnum.CONTEXT_PATH.getName());
        String name = PluginEnum.CONTEXT_PATH.getName();
        String contextPath = PathUtils.decoratorContextPath((String)dto.getContextPath());
        String key = LOCK_KEY_PREFIX + contextPath;
        Lock lock = this.registry.obtain((Object)key);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("register context-path obtain lock for key:{}", (Object)key);
        }
        try {
            lock.lock();
            String contextPathSelectorId = this.getSelectorService().registerDefault(dto, name, "");
            if (Objects.nonNull(this.getRuleService().findBySelectorIdAndName(contextPathSelectorId, dto.getContextPath()))) {
                return;
            }
            ContextMappingRuleHandle handle = new ContextMappingRuleHandle();
            handle.setContextPath(contextPath);
            handle.setAddPrefixed(dto.getAddPrefixed());
            this.getRuleService().registerDefault(this.buildContextPathDefaultRuleDTO(contextPathSelectorId, dto, handle.toJson()));
        }
        finally {
            lock.unlock();
        }
    }
}

