/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.spring;

import com.google.common.base.Splitter;
import jakarta.annotation.Resource;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.apache.shenyu.admin.config.properties.DataBaseProperties;
import org.apache.shenyu.common.exception.ShenyuException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnExpression(value="'${shenyu.database.dialect}' == 'h2'")
public class LocalDataSourceLoader
implements InstantiationAwareBeanPostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(LocalDataSourceLoader.class);
    private static final String PRE_FIX = "file:";
    @Resource
    private DataBaseProperties dataBaseProperties;

    public Object postProcessAfterInitialization(@NonNull Object bean, @NonNull String beanName) throws BeansException {
        if (bean instanceof DataSourceProperties && Boolean.TRUE.equals(this.dataBaseProperties.getInitEnable())) {
            this.init((DataSourceProperties)bean);
        }
        return bean;
    }

    protected void init(DataSourceProperties properties) {
        try {
            String jdbcUrl = StringUtils.replace((String)properties.getUrl(), (String)"/shenyu?", (String)"?");
            try (Connection connection = DriverManager.getConnection(jdbcUrl, properties.getUsername(), properties.getPassword());){
                this.execute(connection, this.dataBaseProperties.getInitScript());
            }
        }
        catch (Exception e) {
            LOG.error("Datasource init error.", (Throwable)e);
            throw new ShenyuException(e.getMessage());
        }
    }

    protected void execute(Connection conn, String script) throws Exception {
        ScriptRunner runner = new ScriptRunner(conn);
        runner.setLogWriter(null);
        runner.setAutoCommit(true);
        runner.setFullLineDelimiter(false);
        runner.setSendFullScript(false);
        runner.setStopOnError(false);
        Resources.setCharset((Charset)StandardCharsets.UTF_8);
        List initScripts = Splitter.on((String)";").splitToList((CharSequence)script);
        for (String sqlScript : initScripts) {
            if (sqlScript.startsWith(PRE_FIX)) {
                String sqlFile = sqlScript.substring(PRE_FIX.length());
                Reader fileReader = LocalDataSourceLoader.getResourceAsReader(sqlFile);
                try {
                    LOG.info("execute shenyu schema sql: {}", (Object)sqlFile);
                    runner.runScript(fileReader);
                    continue;
                }
                finally {
                    if (fileReader != null) {
                        fileReader.close();
                    }
                    continue;
                }
            }
            Reader fileReader = Resources.getResourceAsReader((String)sqlScript);
            try {
                LOG.info("execute shenyu schema sql: {}", (Object)sqlScript);
                runner.runScript(fileReader);
            }
            finally {
                if (fileReader == null) continue;
                fileReader.close();
            }
        }
    }

    private static Reader getResourceAsReader(String resource) throws IOException {
        return new InputStreamReader(Files.newInputStream(Paths.get(resource, new String[0]), new OpenOption[0]), StandardCharsets.UTF_8);
    }
}

