/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.listener.polaris;

import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.configuration.api.core.ConfigFileService;
import java.util.stream.Stream;
import org.apache.shenyu.admin.config.properties.PolarisProperties;
import org.apache.shenyu.admin.listener.AbstractDataChangedInit;
import org.apache.shenyu.common.exception.ShenyuException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolarisDataChangedInit
extends AbstractDataChangedInit {
    private static final Logger LOG = LoggerFactory.getLogger(PolarisDataChangedInit.class);
    private final PolarisProperties polarisProperties;
    private final ConfigFileService configFileService;

    public PolarisDataChangedInit(PolarisProperties polarisProperties, ConfigFileService configFileService) {
        this.polarisProperties = polarisProperties;
        this.configFileService = configFileService;
    }

    protected boolean notExist() {
        return Stream.of("plugin", "auth", "meta", "proxy.selector").allMatch(this::dataIdNotExist);
    }

    private boolean dataIdNotExist(String pluginDataId) {
        try {
            return !this.configFileService.getConfigFile(this.polarisProperties.getNamespace(), this.polarisProperties.getFileGroup(), pluginDataId).hasContent();
        }
        catch (PolarisException e) {
            LOG.error("Get data from polaris error.", (Throwable)e);
            throw new ShenyuException(e.getMessage());
        }
    }
}

