/*
 * Decompiled with CFR 0.152.
 */
package vlsi.utils;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import vlsi.utils.CompactHashMapClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompactHashMapDefaultValues {
    private static Map<Object, Map<Object, Map<Map, Map>>> defaultValues = new HashMap<Object, Map<Object, Map<Map, Map>>>();
    private static ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private static Lock readLock = readWriteLock.readLock();
    private static Lock writeLock = readWriteLock.writeLock();
    public static final String ALL_VALUES_MATCH = new String("All values match");

    public static void clear() {
        writeLock.lock();
        try {
            defaultValues.clear();
        }
        finally {
            writeLock.unlock();
        }
    }

    public static boolean add(Object key) {
        return CompactHashMapDefaultValues.add(key, ALL_VALUES_MATCH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean add(Object key, Object value) {
        writeLock.lock();
        try {
            Map<Object, Map<Map, Map>> m = defaultValues.get(key);
            if (m == null) {
                m = new HashMap<Object, Map<Map, Map>>();
                defaultValues.put(key, m);
            }
            if (m.get(value) != null) {
                boolean bl = false;
                return bl;
            }
            m.put(value, new IdentityHashMap());
            boolean bl = true;
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> Map<K, V> getNewDefaultValues(Map<K, V> prevDefaultValues, K key, Object value) {
        HashMap<K, Object> newMap;
        Map<Map, Map> identityOld2New;
        Map<Object, Map<Map, Map>> m;
        readLock.lock();
        try {
            m = defaultValues.get(key);
            if (m == null) {
                Map<K, V> map = null;
                return map;
            }
            identityOld2New = m.get(value);
            if (identityOld2New == null) {
                if (value != CompactHashMapClass.REMOVED_OBJECT && m.get(ALL_VALUES_MATCH) == null) {
                    Map<K, V> map = null;
                    return map;
                }
            } else {
                newMap = identityOld2New.get(prevDefaultValues);
                if (newMap != null) {
                    HashMap<K, Object> hashMap = newMap;
                    return hashMap;
                }
            }
        }
        finally {
            readLock.unlock();
        }
        newMap = new HashMap<K, Object>((int)((float)(prevDefaultValues.size() + 1) / 0.75f));
        newMap.putAll(prevDefaultValues);
        if (value == CompactHashMapClass.REMOVED_OBJECT) {
            newMap.remove(key);
        } else {
            newMap.put(key, value);
        }
        writeLock.lock();
        try {
            Map anotherNewMap;
            if (identityOld2New == null && (identityOld2New = m.get(value)) == null) {
                identityOld2New = new IdentityHashMap<Map, Map>();
                m.put(value, identityOld2New);
            }
            if ((anotherNewMap = identityOld2New.get(prevDefaultValues)) != null) {
                Map map = anotherNewMap;
                return map;
            }
            identityOld2New.put(prevDefaultValues, newMap);
            HashMap<K, Object> hashMap = newMap;
            return hashMap;
        }
        finally {
            writeLock.unlock();
        }
    }
}

