/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.circuitbreaker.errrate;

import com.tencent.polaris.api.pojo.StatusDimension;
import com.tencent.polaris.plugins.circuitbreaker.common.HalfOpenCounter;
import com.tencent.polaris.plugins.circuitbreaker.common.stat.SliceWindow;
import com.tencent.polaris.plugins.circuitbreaker.errrate.Config;
import com.tencent.polaris.plugins.circuitbreaker.errrate.Dimension;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class ErrRateCounter
extends HalfOpenCounter {
    private final Map<StatusDimension, SliceWindow> sliceWindows = new ConcurrentHashMap<StatusDimension, SliceWindow>();
    private final long bucketIntervalMs;
    private final int metricNumBuckets;
    private final String name;
    private final Function<StatusDimension, SliceWindow> create = new Function<StatusDimension, SliceWindow>(){

        @Override
        public SliceWindow apply(StatusDimension statusDimension) {
            return new SliceWindow(ErrRateCounter.this.name, ErrRateCounter.this.metricNumBuckets, ErrRateCounter.this.bucketIntervalMs, Dimension.maxDimension.ordinal());
        }
    };

    public ErrRateCounter(String name, Config config, long bucketIntervalMs) {
        this.name = name;
        this.bucketIntervalMs = bucketIntervalMs;
        this.metricNumBuckets = config.getMetricNumBuckets();
    }

    public SliceWindow getSliceWindow(StatusDimension statusDimension) {
        return this.sliceWindows.computeIfAbsent(statusDimension, this.create);
    }

    @Override
    public Set<StatusDimension> getStatusDimensions() {
        return this.sliceWindows.keySet();
    }

    @Override
    public void resetCounter(StatusDimension statusDimension) {
    }
}

