/*
 * Decompiled with CFR 0.152.
 */
package shade.polaris.io.grpc.rls;

import java.util.Collections;
import java.util.List;
import shade.polaris.com.google.common.base.Preconditions;
import shade.polaris.io.grpc.Attributes;
import shade.polaris.io.grpc.EquivalentAddressGroup;
import shade.polaris.io.grpc.LoadBalancer;
import shade.polaris.io.grpc.rls.ResolvedAddressFactory;

final class ChildLbResolvedAddressFactory
implements ResolvedAddressFactory {
    private final List<EquivalentAddressGroup> addresses;
    private final Attributes attributes;

    ChildLbResolvedAddressFactory(List<EquivalentAddressGroup> addresses, Attributes attributes) {
        this.addresses = Collections.unmodifiableList(Preconditions.checkNotNull(addresses, "addresses"));
        this.attributes = Preconditions.checkNotNull(attributes, "attributes");
    }

    @Override
    public LoadBalancer.ResolvedAddresses create(Object childLbConfig) {
        return LoadBalancer.ResolvedAddresses.newBuilder().setAddresses(this.addresses).setAttributes(this.attributes).setLoadBalancingPolicyConfig(childLbConfig).build();
    }
}

