/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.handler;

import io.micrometer.observation.ObservationRegistry;
import org.reactivestreams.Subscription;
import org.springframework.integration.handler.MessageHandlerSupport;
import org.springframework.integration.history.MessageHistory;
import org.springframework.integration.support.management.metrics.MetricsCaptor;
import org.springframework.integration.support.management.metrics.SampleFacade;
import org.springframework.integration.support.management.observation.DefaultMessageReceiverObservationConvention;
import org.springframework.integration.support.management.observation.IntegrationObservation;
import org.springframework.integration.support.management.observation.MessageReceiverContext;
import org.springframework.integration.support.management.observation.MessageReceiverObservationConvention;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.util.Assert;
import reactor.core.CoreSubscriber;

public abstract class AbstractMessageHandler
extends MessageHandlerSupport
implements MessageHandler,
CoreSubscriber<Message<?>> {
    @Nullable
    private MessageReceiverObservationConvention observationConvention;

    public void setObservationConvention(@Nullable MessageReceiverObservationConvention observationConvention) {
        this.observationConvention = observationConvention;
    }

    public void handleMessage(Message<?> message) {
        Assert.notNull(message, (String)"Message must not be null");
        if (this.isLoggingEnabled()) {
            this.logger.debug(() -> this + " received message: " + message);
        }
        if (this.isObserved()) {
            this.handleWithObservation(message, this.getObservationRegistry());
        } else {
            MetricsCaptor metricsCaptor = this.getMetricsCaptor();
            if (metricsCaptor != null) {
                this.handleWithMetrics(message, metricsCaptor);
            } else {
                this.doHandleMessage(message);
            }
        }
    }

    private void handleWithObservation(Message<?> message, ObservationRegistry observationRegistry) {
        IntegrationObservation.HANDLER.observation(this.observationConvention, DefaultMessageReceiverObservationConvention.INSTANCE, () -> new MessageReceiverContext(message, this.getComponentName()), observationRegistry).observe(() -> this.doHandleMessage(message));
    }

    private void handleWithMetrics(Message<?> message, MetricsCaptor metricsCaptor) {
        SampleFacade sample = metricsCaptor.start();
        try {
            this.doHandleMessage(message);
            sample.stop(this.sendTimer());
        }
        catch (Exception ex) {
            sample.stop(this.buildSendTimer(false, ex.getClass().getSimpleName()));
            throw ex;
        }
    }

    private void doHandleMessage(Message<?> message) {
        Message<?> messageToUse = message;
        try {
            if (this.shouldTrack()) {
                messageToUse = MessageHistory.write(messageToUse, this, this.getMessageBuilderFactory());
            }
            this.handleMessageInternal(messageToUse);
        }
        catch (Exception ex) {
            throw IntegrationUtils.wrapInHandlingExceptionIfNecessary(messageToUse, () -> "error occurred in message handler [" + this + "]", ex);
        }
    }

    public void onSubscribe(Subscription subscription) {
        Assert.notNull((Object)subscription, (String)"'subscription' must not be null");
        subscription.request(Long.MAX_VALUE);
    }

    public void onError(Throwable throwable) {
    }

    public void onComplete() {
    }

    public void onNext(Message<?> message) {
        this.handleMessage(message);
    }

    protected abstract void handleMessageInternal(Message<?> var1);
}

