/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.shiro.guice;

import org.apache.shiro.lang.util.Destroyable;
import org.junit.jupiter.api.Test;

import static org.easymock.EasyMock.createMock;
import static org.easymock.EasyMock.replay;
import static org.easymock.EasyMock.verify;

class DestroyableInjectionListenerTest {
    @Test
    void testAfterInjection() throws Exception {
        DestroyableInjectionListener.DestroyableRegistry registry =
                createMock(DestroyableInjectionListener.DestroyableRegistry.class);
        Destroyable destroyable = createMock(Destroyable.class);

        registry.add(destroyable);

        replay(registry, destroyable);

        DestroyableInjectionListener<?> underTest = new DestroyableInjectionListener<>(registry);
        underTest.afterInjection(destroyable);

        verify(registry, destroyable);
    }
}
