/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.console;

import java.io.Console;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.EnumMap;
import java.util.Map;
import org.apache.sis.console.Command;
import org.apache.sis.console.Option;
import org.apache.sis.system.Environment;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Printable;
import org.apache.sis.util.Version;
import org.apache.sis.util.resources.Errors;

public final class SIS {
    public static final Help HELP;
    public static final About ABOUT;
    public static final MimeType MIME_TYPE;
    public static final Metadata METADATA;
    public static final Metadata CRS;
    public static final Identifier IDENTIFIER;
    public static final Transform TRANSFORM;
    public static final Translate TRANSLATE;

    private SIS() {
    }

    public static String version() {
        return Version.SIS.toString();
    }

    public static void print(Object value) {
        if (value instanceof Printable) {
            ((Printable)value).print();
        } else {
            PrintWriter out = Environment.writer((Console)System.console(), (PrintStream)System.out);
            out.println(value);
            out.flush();
        }
    }

    static {
        Environment.avoidConsoleWriter();
        HELP = new Help();
        ABOUT = new About();
        MIME_TYPE = new MimeType();
        METADATA = new Metadata("metadata");
        CRS = new Metadata("crs");
        IDENTIFIER = new Identifier();
        TRANSFORM = new Transform();
        TRANSLATE = new Translate();
    }

    public static final class Help
    extends Builder<Help> {
        Help() {
            super("help");
        }

        public Help locale(String value) {
            return (Help)this.set(Option.LOCALE, value);
        }

        public Help encoding(String value) {
            return (Help)this.set(Option.ENCODING, value);
        }
    }

    public static final class About
    extends Builder<About> {
        About() {
            super("about");
        }

        public About locale(String value) {
            return (About)this.set(Option.LOCALE, value);
        }

        public About timezone(String value) {
            return (About)this.set(Option.TIMEZONE, value);
        }

        public About encoding(String value) {
            return (About)this.set(Option.ENCODING, value);
        }

        public About brief() {
            return (About)this.set(Option.BRIEF, null);
        }

        public About verbose() {
            return (About)this.set(Option.VERBOSE, null);
        }
    }

    public static final class MimeType
    extends Builder<MimeType> {
        MimeType() {
            super("mime-type");
        }

        public MimeType encoding(String value) {
            return (MimeType)this.set(Option.ENCODING, value);
        }
    }

    public static final class Metadata
    extends Builder<Metadata> {
        Metadata(String command) {
            super(command);
        }

        public Metadata metadata(String value) {
            return (Metadata)this.set(Option.METADATA, value);
        }

        public Metadata format(String value) {
            return (Metadata)this.set(Option.FORMAT, value);
        }

        public Metadata locale(String value) {
            return (Metadata)this.set(Option.LOCALE, value);
        }

        public Metadata timezone(String value) {
            return (Metadata)this.set(Option.TIMEZONE, value);
        }

        public Metadata encoding(String value) {
            return (Metadata)this.set(Option.ENCODING, value);
        }

        public Metadata colors(boolean enabled) {
            return (Metadata)this.set(Option.COLORS, enabled);
        }

        public Metadata verbose() {
            return (Metadata)this.set(Option.VERBOSE, null);
        }
    }

    public static final class Identifier
    extends Builder<Identifier> {
        Identifier() {
            super("identifier");
        }

        public Identifier locale(String value) {
            return (Identifier)this.set(Option.LOCALE, value);
        }

        public Identifier encoding(String value) {
            return (Identifier)this.set(Option.ENCODING, value);
        }

        public Identifier colors(boolean enabled) {
            return (Identifier)this.set(Option.COLORS, enabled);
        }

        public Identifier verbose() {
            return (Identifier)this.set(Option.VERBOSE, null);
        }
    }

    public static final class Transform
    extends Builder<Transform> {
        Transform() {
            super("transform");
        }

        public Transform sourceCRS(Object value) {
            return (Transform)this.set(Option.SOURCE_CRS, value);
        }

        public Transform targetCRS(Object value) {
            return (Transform)this.set(Option.TARGET_CRS, value);
        }

        public Transform operation(Object value) {
            return (Transform)this.set(Option.OPERATION, value);
        }

        public Transform inverse() {
            return (Transform)this.set(Option.INVERSE, null);
        }

        public Transform locale(String value) {
            return (Transform)this.set(Option.LOCALE, value);
        }

        public Transform timezone(String value) {
            return (Transform)this.set(Option.TIMEZONE, value);
        }

        public Transform encoding(String value) {
            return (Transform)this.set(Option.ENCODING, value);
        }

        public Transform colors(boolean enabled) {
            return (Transform)this.set(Option.COLORS, enabled);
        }

        public Transform verbose() {
            return (Transform)this.set(Option.VERBOSE, null);
        }
    }

    public static final class Translate
    extends Builder<Translate> {
        Translate() {
            super("translate");
        }

        public Translate metadata(String value) {
            return (Translate)this.set(Option.METADATA, value);
        }

        public Translate output(Object value) {
            return (Translate)this.set(Option.OUTPUT, value);
        }

        public Translate format(String value) {
            return (Translate)this.set(Option.FORMAT, value);
        }
    }

    private static abstract class Builder<C extends Builder<C>>
    implements Cloneable {
        private final String command;
        private EnumMap<Option, Object> options;

        Builder(String command) {
            this.command = command;
        }

        final C set(Option key, Object value) {
            if (key.hasValue && (value = Builder.trim(value)) == null) {
                String option = key.label();
                throw new IllegalArgumentException(Errors.format((short)110, (Object)option));
            }
            Builder target = this;
            if (this.options == null) {
                try {
                    target = (Builder)this.clone();
                    target.options = new EnumMap(Option.class);
                }
                catch (CloneNotSupportedException e) {
                    throw new AssertionError((Object)e);
                }
            }
            target.options.put(key, value);
            return (C)target;
        }

        private static Object trim(Object value) {
            if (value instanceof CharSequence) {
                String s = value.toString().trim();
                return s.isBlank() ? null : s;
            }
            return value;
        }

        public C debug() {
            return this.set(Option.DEBUG, null);
        }

        public C help() {
            return this.set(Option.HELP, null);
        }

        public void run(Object ... args) throws Exception {
            int i = 1;
            if (this.options != null) {
                for (Option option : this.options.keySet()) {
                    i += option.hasValue ? 2 : 1;
                }
            }
            Object[] allArgs = new Object[args.length + i];
            i = 0;
            allArgs[i++] = this.command;
            if (this.options != null) {
                for (Map.Entry<Option, Object> entry : this.options.entrySet()) {
                    Option key = entry.getKey();
                    allArgs[i++] = "--".concat(key.label());
                    if (!key.hasValue) continue;
                    allArgs[i++] = entry.getValue();
                }
            }
            System.arraycopy(args, 0, allArgs, i, args.length);
            Command command = new Command(allArgs);
            PrintWriter printWriter = command.writer(false);
            command.setFaintOutput(true);
            printWriter.print("command> sis");
            for (i = 0; i < allArgs.length; ++i) {
                String arg = allArgs[i].toString();
                int start = arg.startsWith("--") ? "--".length() : 0;
                boolean quote = !CharSequences.isUnicodeIdentifier((CharSequence)arg.substring(start));
                printWriter.print(' ');
                if (quote) {
                    printWriter.print('\"');
                }
                printWriter.print(arg.replace("\"", "\\\""));
                if (!quote) continue;
                printWriter.print('\"');
            }
            command.setFaintOutput(false);
            printWriter.println();
            int status = command.run();
            if (status != 0) {
                command.writer(true).println("Error code " + status);
            }
        }

        public String toString() {
            if (this.options == null) {
                return this.command;
            }
            StringBuilder sb = new StringBuilder(this.command);
            this.options.forEach((key, value) -> sb.append(' ').append("--").append(key.label()).append(' ').append(value));
            return sb.toString();
        }
    }
}

