/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.referencing;

import java.util.Locale;
import java.util.Optional;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.concurrent.Task;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.stage.Window;
import javafx.util.Callback;
import javafx.util.Duration;
import org.apache.sis.geometry.ImmutableEnvelope;
import org.apache.sis.gui.internal.BackgroundThreads;
import org.apache.sis.gui.internal.ExceptionReporter;
import org.apache.sis.gui.internal.IdentityValueFactory;
import org.apache.sis.gui.internal.Resources;
import org.apache.sis.gui.internal.Styles;
import org.apache.sis.gui.referencing.AuthorityCodes;
import org.apache.sis.gui.referencing.Code;
import org.apache.sis.gui.referencing.CodeFilter;
import org.apache.sis.gui.referencing.Utils;
import org.apache.sis.gui.referencing.WKTPane;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.Extent;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;

public class CRSChooser
extends Dialog<CoordinateReferenceSystem> {
    private final BorderPane content;
    private final HBox tools;
    private final TextField searchField;
    private final TableView<Code> table;
    private final GridPane summary;
    private final Label type;
    private final Label domain;
    private final ImmutableEnvelope areaOfInterest;
    private WKTPane wktPane;

    public CRSChooser() {
        this(null, null, null);
    }

    public CRSChooser(CRSAuthorityFactory factory, Envelope areaOfInterest, Locale locale) {
        this.areaOfInterest = Utils.toGeographic(CRSChooser.class, "<init>", areaOfInterest);
        if (locale == null) {
            locale = Locale.getDefault();
        }
        Resources i18n = Resources.forLocale(locale);
        Vocabulary vocabulary = Vocabulary.forLocale((Locale)locale);
        AuthorityCodes codeList = new AuthorityCodes(factory, locale);
        this.table = new TableView((ObservableList)codeList);
        codeList.owner = this.table;
        TableColumn codes = new TableColumn(vocabulary.getString((short)28));
        TableColumn names = new TableColumn(vocabulary.getString((short)139));
        names.setCellValueFactory((Callback)codeList);
        codes.setCellValueFactory(IdentityValueFactory.instance());
        codes.setCellFactory(Code.Cell::new);
        codes.setMinWidth(60.0);
        codes.setMaxWidth(120.0);
        this.table.setPrefWidth(500.0);
        this.table.getColumns().setAll((Object[])new TableColumn[]{codes, names});
        this.table.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY_FLEX_LAST_COLUMN);
        Label clock = new Label("\u23f3");
        clock.setFont(Font.font((double)30.0));
        this.table.setPlaceholder((Node)clock);
        this.searchField = new TextField();
        this.searchField.setOnAction(event -> CodeFilter.apply(this.table, this.searchField.getText()));
        HBox.setHgrow((Node)this.searchField, (Priority)Priority.ALWAYS);
        Label label = new Label(vocabulary.getString((short)84));
        label.setLabelFor((Node)this.searchField);
        ToggleButton infoButton = new ToggleButton("\ud83d\uddb9");
        this.table.getSelectionModel().selectedItemProperty().addListener((e, o, n) -> {
            infoButton.setDisable(n == null);
            this.updateSummary((Code)n);
        });
        infoButton.setOnAction(event -> this.setTools(infoButton.isSelected()));
        infoButton.setDisable(true);
        this.tools = new HBox(new Node[]{label, this.searchField, infoButton});
        this.tools.setSpacing(9.0);
        this.tools.setAlignment(Pos.BASELINE_LEFT);
        BorderPane.setMargin((Node)this.tools, (Insets)new Insets(0.0, 0.0, 9.0, 0.0));
        Label lt = new Label(vocabulary.getLabel((short)203));
        Label ld = new Label(vocabulary.getLabel((short)69));
        this.type = new Label();
        lt.setLabelFor((Node)this.type);
        this.domain = new Label();
        ld.setLabelFor((Node)this.domain);
        this.summary = Styles.createControlGrid(0, lt, ld);
        Tooltip tp = new Tooltip();
        tp.setShowDelay(Duration.seconds((double)0.5));
        tp.setShowDuration(Duration.minutes((double)1.0));
        tp.maxWidthProperty().bind((ObservableValue)this.summary.widthProperty());
        tp.setWrapText(true);
        this.domain.setTooltip(tp);
        DialogPane pane = this.getDialogPane();
        this.content = new BorderPane();
        this.content.setCenter(this.table);
        this.content.setTop((Node)this.tools);
        this.content.setBottom((Node)this.summary);
        pane.setContent((Node)this.content);
        pane.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        this.setTitle(i18n.getString((short)30));
        this.setResultConverter(this::getSelectedCRS);
        this.setResizable(true);
    }

    private void setTools(boolean wkt) {
        GridPane info;
        TextArea main;
        ChoiceBox<Convention> control;
        short labelText;
        Locale locale = this.getAuthorityCodes().locale;
        if (wkt) {
            if (this.wktPane == null) {
                this.wktPane = new WKTPane(locale);
            }
            this.wktPane.setContent(this.getAuthorityCodes(), ((Code)this.table.getSelectionModel().getSelectedItem()).code);
            labelText = 85;
            control = this.wktPane.convention;
            main = this.wktPane.text;
            info = null;
        } else {
            labelText = 84;
            control = this.searchField;
            main = this.table;
            info = this.summary;
        }
        ObservableList children = this.tools.getChildren();
        Label label = (Label)children.get(0);
        Vocabulary vocabulary = Vocabulary.forLocale((Locale)locale);
        label.setText(vocabulary.getLabel(labelText));
        label.setLabelFor(control);
        children.set(1, control);
        this.content.setCenter((Node)main);
        this.content.setBottom((Node)info);
    }

    private AuthorityCodes getAuthorityCodes() {
        ObservableList items = this.table.getItems();
        if (items instanceof FilteredList) {
            items = ((FilteredList)items).getSource();
        }
        return (AuthorityCodes)items;
    }

    private void updateSummary(Code selected) {
        if (selected == null) {
            this.clearSummary();
            return;
        }
        final AuthorityCodes source = this.getAuthorityCodes();
        final String code = selected.code;
        BackgroundThreads.execute((Runnable)new Task<CoordinateReferenceSystem>(this){
            final /* synthetic */ CRSChooser this$0;
            {
                this.this$0 = this$0;
            }

            protected CoordinateReferenceSystem call() throws FactoryException {
                return source.getFactory().createCoordinateReferenceSystem(code);
            }

            protected void succeeded() {
                CoordinateReferenceSystem crs = (CoordinateReferenceSystem)this.getValue();
                this.this$0.type.setTextFill((Paint)Styles.NORMAL_TEXT);
                this.this$0.type.setText(CRSChooser.typeOf(crs, source.locale));
                this.this$0.setDomainOfValidity(crs, source.locale);
            }

            protected void cancelled() {
                this.this$0.clearSummary();
            }

            protected void failed() {
                this.cancelled();
                this.this$0.type.setTextFill((Paint)Styles.ERROR_TEXT);
                this.this$0.type.setText(Exceptions.getLocalizedMessage((Throwable)this.getException(), (Locale)source.locale));
            }
        });
    }

    private void clearSummary() {
        this.type.setText(null);
        this.domain.setText(null);
    }

    private void setDomainOfValidity(CoordinateReferenceSystem crs, Locale locale) {
        Object extent = null;
        if (crs != null) {
            extent = Extents.getDescription((Extent)crs.getDomainOfValidity(), (Locale)locale);
        }
        String tip = extent;
        Color color = Styles.NORMAL_TEXT;
        if (!Utils.intersects(this.areaOfInterest, (ReferenceSystem)crs)) {
            tip = Resources.forLocale(locale).getString((short)13);
            extent = "\u26a0\ufe0f " + (String)(extent != null ? extent : tip);
            color = Styles.ERROR_TEXT;
        }
        this.domain.setTextFill((Paint)color);
        this.domain.setText((String)extent);
        this.domain.getTooltip().setText(tip);
    }

    private static String typeOf(CoordinateReferenceSystem crs, Locale locale) {
        int expected;
        int key;
        while (crs instanceof CompoundCRS) {
            crs = (CoordinateReferenceSystem)((CompoundCRS)crs).getComponents().get(0);
        }
        if (crs instanceof GeographicCRS) {
            key = 92;
            expected = 2;
        } else if (crs instanceof GeodeticCRS) {
            key = 86;
            expected = 2;
        } else if (crs instanceof VerticalCRS) {
            key = 220;
            expected = 1;
        } else if (crs instanceof TemporalCRS) {
            key = 191;
            expected = 1;
        } else if (crs instanceof ProjectedCRS) {
            key = 162;
            expected = 2;
        } else if (crs instanceof EngineeringCRS) {
            key = 77;
            expected = 0;
        } else {
            key = 207;
            expected = 0;
        }
        String text = Vocabulary.forLocale((Locale)locale).getString((short)key);
        int dimension = CRS.getDimensionOrZero((CoordinateReferenceSystem)crs);
        boolean addDimension = dimension != expected && expected != 0;
        boolean isProjection = crs instanceof GeneralDerivedCRS;
        if (addDimension | isProjection) {
            String name;
            OperationMethod method;
            Conversion conversion;
            StringBuilder buffer = new StringBuilder(text);
            if (addDimension) {
                buffer.append(" (").append(dimension).append("D)");
            }
            if (isProjection && (conversion = ((GeneralDerivedCRS)crs).getConversionFromBase()) != null && (method = conversion.getMethod()) != null && (name = IdentifiedObjects.getDisplayName((IdentifiedObject)method, (Locale)locale)) != null) {
                buffer.append(" \u2014 ").append(name);
            }
            text = buffer.toString();
        }
        return text;
    }

    private CoordinateReferenceSystem getSelectedCRS(ButtonType button) {
        Code code;
        if (ButtonType.OK.equals(button) && (code = (Code)this.table.getSelectionModel().getSelectedItem()) != null) {
            try {
                return this.getAuthorityCodes().getFactory().createCoordinateReferenceSystem(code.code);
            }
            catch (FactoryException e) {
                ExceptionReporter.canNotCreateCRS(this.getOwner(), code.code, e);
            }
        }
        return null;
    }

    public Optional<CoordinateReferenceSystem> showDialog(Window parent) {
        this.initOwner(parent);
        return this.showAndWait();
    }
}

