/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter.sqlmm;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.sqlmm.FunctionWithSRID;
import org.apache.sis.filter.sqlmm.SQLMM;
import org.apache.sis.geometry.wrapper.Geometries;
import org.apache.sis.geometry.wrapper.GeometryWrapper;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

final class ST_Point<R>
extends FunctionWithSRID<R> {
    private static final long serialVersionUID = -6280773709322350835L;
    private final Expression<R, ?>[] parameters;
    private final Geometries<?> library;

    ST_Point(Expression<R, ?>[] parameters, Geometries<?> library) {
        super(SQLMM.ST_Point, parameters, 2);
        this.parameters = parameters;
        this.library = library;
    }

    @Override
    public Expression<R, Object> recreate(Expression<R, ?>[] effective) {
        return new ST_Point<R>(effective, this.getGeometryLibrary());
    }

    @Override
    final Geometries<?> getGeometryLibrary() {
        return this.library;
    }

    @Override
    public Class<? super R> getResourceClass() {
        Class type = super.getResourceClass();
        for (Expression<R, ?> p : this.parameters) {
            type = ST_Point.specializedClass(type, p.getResourceClass());
        }
        return type;
    }

    @Override
    public List<Expression<R, ?>> getParameters() {
        return Containers.viewAsUnmodifiableList((Object[])this.parameters);
    }

    private double value(R input, int index, String name) {
        Object value = this.parameters[index].apply(input);
        if (value == null) {
            return Double.NaN;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        throw new IllegalArgumentException(Errors.format((short)58, (Object)name, Number.class, value.getClass()));
    }

    private GeometryWrapper parse(Object value) throws Exception {
        GeometryWrapper point;
        if (value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            point = this.library.parseWKB(ByteBuffer.wrap((byte[])value));
        } else if (value instanceof ByteBuffer) {
            point = this.library.parseWKB((ByteBuffer)value);
        } else if (value instanceof String) {
            point = this.library.parseWKT((String)value);
        } else {
            throw new IllegalArgumentException(Errors.format((short)58, (Object)"wkt|wkb", String.class, value.getClass()));
        }
        Object geometry = this.library.getGeometry(point);
        if (this.library.pointClass.isInstance(geometry)) {
            return point;
        }
        String type = value instanceof String ? "wkt" : "wkb";
        throw new IllegalArgumentException(Errors.format((short)58, (Object)type, this.library.pointClass, point.getClass()));
    }

    @Override
    public Object apply(R input) {
        CoordinateReferenceSystem crs;
        GeometryWrapper point;
        try {
            switch (this.parameters.length) {
                case 1: {
                    GeometryWrapper point2 = this.parse(this.parameters[0].apply(input));
                    return this.library.getGeometry(point2);
                }
                case 2: {
                    Object value = this.parameters[0].apply(input);
                    if (value instanceof Number) {
                        double x = ((Number)value).doubleValue();
                        double y = this.value(input, 1, "y");
                        if (Double.isNaN(x) && Double.isNaN(y)) {
                            return null;
                        }
                        return this.library.createPoint(x, y);
                    }
                    point = this.parse(value);
                    if (point == null) {
                        return null;
                    }
                    crs = this.getTargetCRS(input);
                    break;
                }
                case 3: {
                    double x = this.value(input, 0, "x");
                    double y = this.value(input, 1, "y");
                    if (this.literalCRS) {
                        if (Double.isNaN(x) && Double.isNaN(y)) {
                            return null;
                        }
                        point = this.library.castOrWrap(this.library.createPoint(x, y));
                        crs = this.getTargetCRS(input);
                        break;
                    }
                    double z = this.value(input, 2, "z");
                    if (Double.isNaN(x) && Double.isNaN(y) && Double.isNaN(z)) {
                        return null;
                    }
                    return this.library.createPoint(x, y, z);
                }
                case 4: {
                    double x = this.value(input, 0, "x");
                    double y = this.value(input, 1, "y");
                    double z = this.value(input, 2, "z");
                    if (Double.isNaN(x) && Double.isNaN(y) && Double.isNaN(z)) {
                        return null;
                    }
                    point = this.library.castOrWrap(this.library.createPoint(x, y, z));
                    crs = this.getTargetCRS(input);
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        catch (Exception e) {
            this.warning(e);
            return null;
        }
        if (crs != null) {
            point.setCoordinateReferenceSystem(crs);
        }
        return this.library.getGeometry(point);
    }
}

