/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.converter;

import java.util.Date;
import java.util.ServiceLoader;
import org.apache.sis.converter.CharSequenceConverter;
import org.apache.sis.converter.ConverterRegistry;
import org.apache.sis.converter.NumberConverter;
import org.apache.sis.converter.ObjectToString;
import org.apache.sis.converter.StringConverter;
import org.apache.sis.converter.SystemConverter;
import org.apache.sis.math.NumberType;
import org.apache.sis.system.Reflect;
import org.apache.sis.system.SystemListener;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.UnconvertibleObjectException;
import org.opengis.util.CodeList;

public final class SystemRegistry
extends ConverterRegistry {
    public static final ConverterRegistry INSTANCE = new SystemRegistry();

    private SystemRegistry() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void initialize() {
        ServiceLoader<ObjectConverter> loader;
        try {
            loader = ServiceLoader.load(ObjectConverter.class, Reflect.getContextClassLoader());
        }
        catch (SecurityException e) {
            Reflect.log(SystemRegistry.class, "initialize", e);
            loader = ServiceLoader.load(ObjectConverter.class);
        }
        for (ObjectConverter objectConverter : loader) {
            void var3_4;
            if (objectConverter instanceof SystemConverter) {
                ObjectConverter objectConverter2 = ((SystemConverter)objectConverter).unique();
            }
            this.register(var3_4);
        }
    }

    private static boolean tryInverse(Class<?> targetClass) {
        return targetClass == String.class || targetClass == Date.class;
    }

    @Override
    protected <S, T> ObjectConverter<S, T> createConverter(Class<S> sourceClass, Class<T> targetClass) {
        ObjectConverter<S, T> identity;
        if (SystemRegistry.tryInverse(targetClass) && !SystemRegistry.tryInverse(sourceClass)) {
            try {
                return this.findExact(targetClass, sourceClass).inverse();
            }
            catch (UnconvertibleObjectException unconvertibleObjectException) {
                // empty catch block
            }
        }
        if ((identity = super.createConverter(sourceClass, targetClass)) != null) {
            return identity;
        }
        if (sourceClass == CharSequence.class) {
            return new CharSequenceConverter<T>(targetClass, this.find(String.class, targetClass));
        }
        if (sourceClass == String.class) {
            if (CodeList.class.isAssignableFrom(targetClass)) {
                return new StringConverter.CodeList<CodeList>(targetClass.asSubclass(CodeList.class));
            }
            if (targetClass.isEnum()) {
                return new StringConverter.Enum<Enum>(targetClass.asSubclass(Enum.class));
            }
        }
        if (sourceClass == Number.class || SystemRegistry.isSupportedNumber(sourceClass)) {
            if (SystemRegistry.isSupportedNumber(targetClass)) {
                return new NumberConverter<Number, Number>(sourceClass.asSubclass(Number.class), targetClass.asSubclass(Number.class));
            }
            if (targetClass == Comparable.class) {
                return new NumberConverter.Comparable<Number>(sourceClass.asSubclass(Number.class));
            }
        }
        if (targetClass == String.class) {
            return new ObjectToString<S>(sourceClass, null);
        }
        return null;
    }

    private static boolean isSupportedNumber(Class<?> type) {
        return NumberType.forClass(type).filter(NumberType::isReal).isPresent();
    }

    static {
        SystemListener.add(new SystemListener("org.apache.sis.util"){

            @Override
            protected void classpathChanged() {
                INSTANCE.clear();
            }
        });
    }
}

