/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.collection;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

final class DerivedList<S, E>
extends AbstractList<E>
implements Serializable {
    private static final long serialVersionUID = 5616103170191124327L;
    private final List<S> source;
    private final Function<S, E> adapter;

    DerivedList(List<S> source, Function<S, E> adapter) {
        this.source = source;
        this.adapter = adapter;
    }

    @Override
    public boolean isEmpty() {
        return this.source.isEmpty();
    }

    @Override
    public int size() {
        return this.source.size();
    }

    @Override
    public E get(int i) {
        return this.adapter.apply(this.source.get(i));
    }

    @Override
    public E remove(int i) {
        return this.adapter.apply(this.source.remove(i));
    }

    @Override
    public Stream<E> stream() {
        return this.source.stream().map(this.adapter);
    }

    @Override
    public Stream<E> parallelStream() {
        return this.source.parallelStream().map(this.adapter);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return new DerivedList<S, E>(this.source.subList(fromIndex, toIndex), this.adapter);
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        this.source.forEach(DerivedList.adapt(this.adapter, action));
    }

    private static <S, E> Consumer<S> adapt(Function<S, E> adapter, Consumer<? super E> action) {
        return e -> action.accept((Object)adapter.apply(e));
    }

    @Override
    public Iterator<E> iterator() {
        return new Iter<S, E>(this.source.iterator(), this.adapter);
    }

    private static final class Iter<S, E>
    implements Iterator<E> {
        private final Iterator<S> source;
        private final Function<S, E> adapter;

        Iter(Iterator<S> source, Function<S, E> adapter) {
            this.source = source;
            this.adapter = adapter;
        }

        @Override
        public boolean hasNext() {
            return this.source.hasNext();
        }

        @Override
        public E next() {
            return this.adapter.apply(this.source.next());
        }

        @Override
        public void remove() {
            this.source.remove();
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            this.source.forEachRemaining(DerivedList.adapt(this.adapter, action));
        }
    }
}

