/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.internals;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.TopicIdPartition;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.TopicPartition;

public final class Utils {

    public static final class TopicIdPartitionComparator
    implements Comparator<TopicIdPartition>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(TopicIdPartition topicPartition1, TopicIdPartition topicPartition2) {
            String topic2;
            String topic1 = topicPartition1.topic();
            if (topic1.equals(topic2 = topicPartition2.topic())) {
                return topicPartition1.partition() - topicPartition2.partition();
            }
            return topic1.compareTo(topic2);
        }
    }

    public static final class TopicPartitionComparator
    implements Comparator<TopicPartition>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(TopicPartition topicPartition1, TopicPartition topicPartition2) {
            String topic2;
            String topic1 = topicPartition1.topic();
            if (topic1.equals(topic2 = topicPartition2.topic())) {
                return topicPartition1.partition() - topicPartition2.partition();
            }
            return topic1.compareTo(topic2);
        }
    }

    static final class PartitionComparator
    implements Comparator<TopicPartition>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Map<String, List<String>> map;

        PartitionComparator(Map<String, List<String>> map) {
            this.map = map;
        }

        @Override
        public int compare(TopicPartition o1, TopicPartition o2) {
            int ret = this.map.get(o1.topic()).size() - this.map.get(o2.topic()).size();
            if (ret == 0 && (ret = o1.topic().compareTo(o2.topic())) == 0) {
                ret = o1.partition() - o2.partition();
            }
            return ret;
        }
    }
}

