/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.IsolationLevel;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.TopicIdPartition;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.TopicPartition;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.Uuid;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.message.FetchRequestData;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.message.FetchResponseData;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.Errors;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests.AbstractRequest;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests.AbstractResponse;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests.FetchMetadata;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.requests.FetchResponse;

public class FetchRequest
extends AbstractRequest {
    public static final int CONSUMER_REPLICA_ID = -1;
    public static final int DEFAULT_RESPONSE_MAX_BYTES = Integer.MAX_VALUE;
    public static final long INVALID_LOG_START_OFFSET = -1L;
    public static final int ORDINARY_CONSUMER_ID = -1;
    public static final int DEBUGGING_CONSUMER_ID = -2;
    public static final int FUTURE_LOCAL_REPLICA_ID = -3;
    private final FetchRequestData data;
    private volatile LinkedHashMap<TopicIdPartition, PartitionData> fetchData = null;
    private final FetchMetadata metadata;

    private static Optional<Integer> optionalEpoch(int rawEpochValue) {
        if (rawEpochValue < 0) {
            return Optional.empty();
        }
        return Optional.of(rawEpochValue);
    }

    public static int replicaId(FetchRequestData fetchRequestData) {
        return fetchRequestData.replicaId() != -1 ? fetchRequestData.replicaId() : fetchRequestData.replicaState().replicaId();
    }

    public FetchRequest(FetchRequestData fetchRequestData, short version) {
        super(ApiKeys.FETCH, version);
        this.data = fetchRequestData;
        this.metadata = new FetchMetadata(fetchRequestData.sessionId(), fetchRequestData.sessionEpoch());
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        Errors error = Errors.forException(e);
        ArrayList<FetchResponseData.FetchableTopicResponse> topicResponseList = new ArrayList<FetchResponseData.FetchableTopicResponse>();
        if (this.version() < 13) {
            this.data.topics().forEach(topic -> {
                List<FetchResponseData.PartitionData> partitionResponses = topic.partitions().stream().map(partition -> FetchResponse.partitionResponse(partition.partition(), error)).collect(Collectors.toList());
                topicResponseList.add(new FetchResponseData.FetchableTopicResponse().setTopic(topic.topic()).setTopicId(topic.topicId()).setPartitions(partitionResponses));
            });
        }
        return new FetchResponse(new FetchResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(error.code()).setSessionId(this.data.sessionId()).setResponses(topicResponseList));
    }

    public int replicaId() {
        if (this.version() < 15) {
            return this.data.replicaId();
        }
        return this.data.replicaState().replicaId();
    }

    public long replicaEpoch() {
        return this.data.replicaState().replicaEpoch();
    }

    public int maxWait() {
        return this.data.maxWaitMs();
    }

    public int minBytes() {
        return this.data.minBytes();
    }

    public int maxBytes() {
        return this.data.maxBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<TopicIdPartition, PartitionData> fetchData(Map<Uuid, String> topicNames) {
        if (this.fetchData == null) {
            FetchRequest fetchRequest = this;
            synchronized (fetchRequest) {
                if (this.fetchData == null) {
                    LinkedHashMap fetchDataTmp = new LinkedHashMap();
                    short version = this.version();
                    this.data.topics().forEach(fetchTopic -> {
                        String name = version < 13 ? fetchTopic.topic() : (String)topicNames.get(fetchTopic.topicId());
                        fetchTopic.partitions().forEach(fetchPartition -> fetchDataTmp.put(new TopicIdPartition(fetchTopic.topicId(), new TopicPartition(name, fetchPartition.partition())), new PartitionData(fetchTopic.topicId(), fetchPartition.fetchOffset(), fetchPartition.logStartOffset(), fetchPartition.partitionMaxBytes(), FetchRequest.optionalEpoch(fetchPartition.currentLeaderEpoch()), FetchRequest.optionalEpoch(fetchPartition.lastFetchedEpoch()))));
                    });
                    this.fetchData = fetchDataTmp;
                }
            }
        }
        return this.fetchData;
    }

    public List<TopicIdPartition> forgottenTopics(Map<Uuid, String> topicNames) {
        ArrayList<TopicIdPartition> toForget = new ArrayList<TopicIdPartition>();
        this.data.forgottenTopicsData().forEach(forgottenTopic -> {
            String name = this.version() < 13 ? forgottenTopic.topic() : (String)topicNames.get(forgottenTopic.topicId());
            forgottenTopic.partitions().forEach(partitionId -> toForget.add(new TopicIdPartition(forgottenTopic.topicId(), new TopicPartition(name, (int)partitionId))));
        });
        return toForget;
    }

    public boolean isFromFollower() {
        return this.replicaId() >= 0;
    }

    public IsolationLevel isolationLevel() {
        return IsolationLevel.forId(this.data.isolationLevel());
    }

    public FetchMetadata metadata() {
        return this.metadata;
    }

    public String rackId() {
        return this.data.rackId();
    }

    public static FetchRequest parse(ByteBuffer buffer, short version) {
        return new FetchRequest(new FetchRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    public static boolean isValidBrokerId(int brokerId) {
        return brokerId >= 0;
    }

    public static boolean isConsumer(int replicaId) {
        return replicaId < 0 && replicaId != -3;
    }

    public static String describeReplicaId(int replicaId) {
        switch (replicaId) {
            case -1: {
                return "consumer";
            }
            case -2: {
                return "debug consumer";
            }
            case -3: {
                return "future local replica";
            }
        }
        if (FetchRequest.isValidBrokerId(replicaId)) {
            return "replica [" + replicaId + "]";
        }
        return "invalid replica [" + replicaId + "]";
    }

    @Override
    public FetchRequestData data() {
        return this.data;
    }

    public static class Builder
    extends AbstractRequest.Builder<FetchRequest> {
        private final int maxWait;
        private final int minBytes;
        private final int replicaId;
        private final long replicaEpoch;
        private final Map<TopicPartition, PartitionData> toFetch;
        private IsolationLevel isolationLevel = IsolationLevel.READ_UNCOMMITTED;
        private int maxBytes = Integer.MAX_VALUE;
        private FetchMetadata metadata = FetchMetadata.LEGACY;
        private List<TopicIdPartition> removed = Collections.emptyList();
        private List<TopicIdPartition> replaced = Collections.emptyList();
        private String rackId = "";

        public static Builder forConsumer(short maxVersion, int maxWait, int minBytes, Map<TopicPartition, PartitionData> fetchData) {
            return new Builder(ApiKeys.FETCH.oldestVersion(), maxVersion, -1, -1L, maxWait, minBytes, fetchData);
        }

        public static Builder forReplica(short allowedVersion, int replicaId, long replicaEpoch, int maxWait, int minBytes, Map<TopicPartition, PartitionData> fetchData) {
            return new Builder(allowedVersion, allowedVersion, replicaId, replicaEpoch, maxWait, minBytes, fetchData);
        }

        public Builder(short minVersion, short maxVersion, int replicaId, long replicaEpoch, int maxWait, int minBytes, Map<TopicPartition, PartitionData> fetchData) {
            super(ApiKeys.FETCH, minVersion, maxVersion);
            this.replicaId = replicaId;
            this.replicaEpoch = replicaEpoch;
            this.maxWait = maxWait;
            this.minBytes = minBytes;
            this.toFetch = fetchData;
        }

        public Builder isolationLevel(IsolationLevel isolationLevel) {
            this.isolationLevel = isolationLevel;
            return this;
        }

        public FetchMetadata metadata() {
            return this.metadata;
        }

        public Builder metadata(FetchMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder rackId(String rackId) {
            this.rackId = rackId;
            return this;
        }

        public Map<TopicPartition, PartitionData> fetchData() {
            return this.toFetch;
        }

        public Builder setMaxBytes(int maxBytes) {
            this.maxBytes = maxBytes;
            return this;
        }

        public List<TopicIdPartition> removed() {
            return this.removed;
        }

        public Builder removed(List<TopicIdPartition> removed) {
            this.removed = removed;
            return this;
        }

        public List<TopicIdPartition> replaced() {
            return this.replaced;
        }

        public Builder replaced(List<TopicIdPartition> replaced) {
            this.replaced = replaced;
            return this;
        }

        private void addToForgottenTopicMap(List<TopicIdPartition> toForget, Map<String, FetchRequestData.ForgottenTopic> forgottenTopicMap) {
            toForget.forEach(topicIdPartition -> {
                FetchRequestData.ForgottenTopic forgottenTopic = (FetchRequestData.ForgottenTopic)forgottenTopicMap.get(topicIdPartition.topic());
                if (forgottenTopic == null) {
                    forgottenTopic = new FetchRequestData.ForgottenTopic().setTopic(topicIdPartition.topic()).setTopicId(topicIdPartition.topicId());
                    forgottenTopicMap.put(topicIdPartition.topic(), forgottenTopic);
                }
                forgottenTopic.partitions().add(topicIdPartition.partition());
            });
        }

        @Override
        public FetchRequest build(short version) {
            if (version < 3) {
                this.maxBytes = Integer.MAX_VALUE;
            }
            FetchRequestData fetchRequestData = new FetchRequestData();
            fetchRequestData.setMaxWaitMs(this.maxWait);
            fetchRequestData.setMinBytes(this.minBytes);
            fetchRequestData.setMaxBytes(this.maxBytes);
            fetchRequestData.setIsolationLevel(this.isolationLevel.id());
            fetchRequestData.setForgottenTopicsData(new ArrayList<FetchRequestData.ForgottenTopic>());
            if (version < 15) {
                fetchRequestData.setReplicaId(this.replicaId);
            } else {
                fetchRequestData.setReplicaState(new FetchRequestData.ReplicaState().setReplicaId(this.replicaId).setReplicaEpoch(this.replicaEpoch));
            }
            LinkedHashMap<String, FetchRequestData.ForgottenTopic> forgottenTopicMap = new LinkedHashMap<String, FetchRequestData.ForgottenTopic>();
            this.addToForgottenTopicMap(this.removed, forgottenTopicMap);
            if (version >= 13) {
                this.addToForgottenTopicMap(this.replaced, forgottenTopicMap);
            }
            forgottenTopicMap.forEach((topic, forgottenTopic) -> fetchRequestData.forgottenTopicsData().add((FetchRequestData.ForgottenTopic)forgottenTopic));
            fetchRequestData.setTopics(new ArrayList<FetchRequestData.FetchTopic>());
            FetchRequestData.FetchTopic fetchTopic = null;
            for (Map.Entry<TopicPartition, PartitionData> entry : this.toFetch.entrySet()) {
                TopicPartition topicPartition = entry.getKey();
                PartitionData partitionData = entry.getValue();
                if (fetchTopic == null || !topicPartition.topic().equals(fetchTopic.topic())) {
                    fetchTopic = new FetchRequestData.FetchTopic().setTopic(topicPartition.topic()).setTopicId(partitionData.topicId).setPartitions(new ArrayList<FetchRequestData.FetchPartition>());
                    fetchRequestData.topics().add(fetchTopic);
                }
                FetchRequestData.FetchPartition fetchPartition = new FetchRequestData.FetchPartition().setPartition(topicPartition.partition()).setCurrentLeaderEpoch(partitionData.currentLeaderEpoch.orElse(-1)).setLastFetchedEpoch(partitionData.lastFetchedEpoch.orElse(-1)).setFetchOffset(partitionData.fetchOffset).setLogStartOffset(partitionData.logStartOffset).setPartitionMaxBytes(partitionData.maxBytes);
                fetchTopic.partitions().add(fetchPartition);
            }
            if (this.metadata != null) {
                fetchRequestData.setSessionEpoch(this.metadata.epoch());
                fetchRequestData.setSessionId(this.metadata.sessionId());
            }
            fetchRequestData.setRackId(this.rackId);
            return new FetchRequest(fetchRequestData, version);
        }

        public String toString() {
            return "(type=FetchRequest, replicaId=" + this.replicaId + ", maxWait=" + this.maxWait + ", minBytes=" + this.minBytes + ", maxBytes=" + this.maxBytes + ", fetchData=" + this.toFetch + ", isolationLevel=" + (Object)((Object)this.isolationLevel) + ", removed=" + this.removed.stream().map(TopicIdPartition::toString).collect(Collectors.joining(", ")) + ", replaced=" + this.replaced.stream().map(TopicIdPartition::toString).collect(Collectors.joining(", ")) + ", metadata=" + this.metadata + ", rackId=" + this.rackId + ")";
        }
    }

    public static class SimpleBuilder
    extends AbstractRequest.Builder<FetchRequest> {
        private final FetchRequestData fetchRequestData;

        public SimpleBuilder(FetchRequestData fetchRequestData) {
            super(ApiKeys.FETCH);
            this.fetchRequestData = fetchRequestData;
        }

        @Override
        public FetchRequest build(short version) {
            if (this.fetchRequestData.replicaId() >= 0) {
                throw new IllegalStateException("The replica id should be placed in the replicaState of a fetchRequestData");
            }
            if (version < 15) {
                this.fetchRequestData.setReplicaId(this.fetchRequestData.replicaState().replicaId());
                this.fetchRequestData.setReplicaState(new FetchRequestData.ReplicaState());
            }
            return new FetchRequest(this.fetchRequestData, version);
        }
    }

    public static final class PartitionData {
        public final Uuid topicId;
        public final long fetchOffset;
        public final long logStartOffset;
        public final int maxBytes;
        public final Optional<Integer> currentLeaderEpoch;
        public final Optional<Integer> lastFetchedEpoch;

        public PartitionData(Uuid topicId, long fetchOffset, long logStartOffset, int maxBytes, Optional<Integer> currentLeaderEpoch) {
            this(topicId, fetchOffset, logStartOffset, maxBytes, currentLeaderEpoch, Optional.empty());
        }

        public PartitionData(Uuid topicId, long fetchOffset, long logStartOffset, int maxBytes, Optional<Integer> currentLeaderEpoch, Optional<Integer> lastFetchedEpoch) {
            this.topicId = topicId;
            this.fetchOffset = fetchOffset;
            this.logStartOffset = logStartOffset;
            this.maxBytes = maxBytes;
            this.currentLeaderEpoch = currentLeaderEpoch;
            this.lastFetchedEpoch = lastFetchedEpoch;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PartitionData that = (PartitionData)o;
            return Objects.equals(this.topicId, that.topicId) && this.fetchOffset == that.fetchOffset && this.logStartOffset == that.logStartOffset && this.maxBytes == that.maxBytes && Objects.equals(this.currentLeaderEpoch, that.currentLeaderEpoch) && Objects.equals(this.lastFetchedEpoch, that.lastFetchedEpoch);
        }

        public int hashCode() {
            return Objects.hash(this.topicId, this.fetchOffset, this.logStartOffset, this.maxBytes, this.currentLeaderEpoch, this.lastFetchedEpoch);
        }

        public String toString() {
            return "PartitionData(topicId=" + this.topicId + ", fetchOffset=" + this.fetchOffset + ", logStartOffset=" + this.logStartOffset + ", maxBytes=" + this.maxBytes + ", currentLeaderEpoch=" + this.currentLeaderEpoch + ", lastFetchedEpoch=" + this.lastFetchedEpoch + ')';
        }
    }
}

