/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jackrabbit.usermanager.impl.resource;

import java.util.Map;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.sling.adapter.annotations.Adaptable;
import org.apache.sling.adapter.annotations.Adapter;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.jackrabbit.usermanager.impl.resource.AuthorizableResource;
import org.apache.sling.jackrabbit.usermanager.impl.resource.NestedAuthorizableValueMap;
import org.apache.sling.jackrabbit.usermanager.resource.SystemUserManagerPaths;

@Adaptable(adaptableClass=Resource.class, adapters={@Adapter(value={Map.class, ValueMap.class, Authorizable.class}), @Adapter(condition="If the resource is an AuthorizableResource and represents a JCR User", value={User.class}), @Adapter(condition="If the resource is an AuthorizableResource and represents a JCR Group", value={Group.class})})
public class NestedAuthorizableResource
extends AuthorizableResource {
    private final String relPropPath;

    public NestedAuthorizableResource(Authorizable authorizable, ResourceResolver resourceResolver, String path, SystemUserManagerPaths systemUserManagerPaths, String relPropPath) {
        super(authorizable, resourceResolver, path, systemUserManagerPaths);
        this.relPropPath = relPropPath;
    }

    @Override
    protected String toResourceType(Authorizable authorizable) {
        return String.format("%s/properties", super.toResourceType(authorizable));
    }

    @Override
    public <T> T adaptTo(Class<T> type) {
        if (type == Map.class || type == ValueMap.class) {
            NestedAuthorizableValueMap valueMap = new NestedAuthorizableValueMap(this.authorizable, this.systemUserManagerPaths, this.relPropPath);
            return type.cast(valueMap);
        }
        return super.adaptTo(type);
    }
}

