/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.core.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import javax.script.ScriptEngineFactory;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.apache.sling.scripting.core.impl.jsr223.SlingScriptEngineManager;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"service.description=Web Console Plugin for ScriptEngine implementations", "service.vendor=The Apache Software Foundation", "felix.webconsole.label=slingscripting", "felix.webconsole.title=Script Engines", "felix.webconsole.configprinter.modes=always", "felix.webconsole.category=Status"}, service={Servlet.class})
public class ScriptEngineConsolePlugin
extends AbstractWebConsolePlugin {
    private static final long serialVersionUID = -6444729200748932100L;
    public static final String CONSOLE_LABEL = "slingscripting";
    public static final String CONSOLE_TITLE = "Script Engines";
    @Reference
    private SlingScriptEngineManager slingScriptEngineManager;

    public String getTitle() {
        return CONSOLE_TITLE;
    }

    public String getLabel() {
        return CONSOLE_LABEL;
    }

    protected void renderContent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        PrintWriter pw = httpServletResponse.getWriter();
        pw.println("<div id='content' class='ui-widget'><br>");
        pw.println("<pre>");
        pw.println("Available Script Engines");
        pw.println("========================");
        List<ScriptEngineFactory> factories = this.slingScriptEngineManager.getEngineFactories();
        for (ScriptEngineFactory factory : factories) {
            pw.println();
            pw.print(factory.getEngineName());
            pw.print(" ");
            pw.println(factory.getEngineVersion());
            pw.println("-------------------------------------");
            pw.print("- Language : ");
            pw.print(factory.getLanguageName());
            pw.print(", ");
            pw.println(factory.getLanguageVersion());
            pw.print("- Extensions : ");
            this.printArray(pw, factory.getExtensions());
            pw.print("- MIME Types : ");
            this.printArray(pw, factory.getMimeTypes());
            pw.print("- Names : ");
            this.printArray(pw, factory.getNames());
        }
        pw.println("</pre>");
        pw.println("</div>");
    }

    private void printArray(PrintWriter pw, List<?> values) {
        if (values == null || values.isEmpty()) {
            pw.println("-");
        } else {
            Iterator<?> vi = values.iterator();
            while (vi.hasNext()) {
                pw.print(vi.next());
                if (!vi.hasNext()) continue;
                pw.print(", ");
            }
            pw.println();
        }
    }
}

