/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine.extension.use;

import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.scripting.SlingScript;
import org.apache.sling.scripting.core.ScriptNameAwareReader;
import org.apache.sling.scripting.sightly.SightlyException;
import org.apache.sling.scripting.sightly.impl.engine.bundled.BundledUnitManagerImpl;
import org.apache.sling.scripting.sightly.impl.utils.BindingsUtils;
import org.apache.sling.scripting.sightly.impl.utils.ScriptDependencyResolver;
import org.apache.sling.scripting.sightly.render.RenderContext;
import org.apache.sling.scripting.sightly.use.ProviderOutcome;
import org.apache.sling.scripting.sightly.use.UseProvider;
import org.apache.sling.scripting.spi.bundle.BundledRenderUnit;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={UseProvider.class}, configurationPid={"org.apache.sling.scripting.sightly.impl.engine.extension.use.ScriptUseProvider"}, property={"service.ranking:Integer=0"})
public class ScriptUseProvider
implements UseProvider {
    private static final Logger log = LoggerFactory.getLogger(ScriptUseProvider.class);
    private final AtomicReference<ScriptEngineManager> engineManagerRef = new AtomicReference();
    private final BundleContext bundleContext;
    private final BundledUnitManagerImpl bundledUnitManager;
    protected final ScriptDependencyResolver scriptDependencyResolver;
    private ServiceReference<ScriptEngineManager> scriptEngineManagerServiceReference;

    @Activate
    public ScriptUseProvider(BundleContext bundleContext, @Reference BundledUnitManagerImpl bundledUnitManager, @Reference ScriptDependencyResolver scriptDependencyResolver) {
        this.bundleContext = bundleContext;
        this.bundledUnitManager = bundledUnitManager;
        this.scriptDependencyResolver = scriptDependencyResolver;
    }

    @Deactivate
    protected void deactivate() {
        if (this.scriptEngineManagerServiceReference != null) {
            this.bundleContext.ungetService(this.scriptEngineManagerServiceReference);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ProviderOutcome provide(String scriptName, RenderContext renderContext, Bindings arguments) {
        Resource scriptResource;
        Bindings globalBindings = renderContext.getBindings();
        Bindings bindings = BindingsUtils.merge(globalBindings, arguments);
        String extension = this.scriptExtension(scriptName);
        if (extension == null) return ProviderOutcome.failure();
        if (extension.equals("html")) {
            return ProviderOutcome.failure();
        }
        URL script = this.bundledUnitManager.getScript(bindings, scriptName);
        if (script != null) {
            String scriptUrlAsString = script.toExternalForm();
            bindings.remove(BundledRenderUnit.VARIABLE);
            bindings.put("javax.script.filename", (Object)scriptUrlAsString);
            ScriptEngineManager scriptEngineManager = this.getScriptEngineManager();
            if (scriptEngineManager == null) {
                return ProviderOutcome.failure((Throwable)new SightlyException("Failed to obtain a ScriptEngineManager."));
            }
            ScriptEngine scriptEngine = scriptEngineManager.getEngineByExtension(extension);
            if (scriptEngine != null) {
                try (ScriptNameAwareReader reader = new ScriptNameAwareReader((Reader)new InputStreamReader(script.openStream(), StandardCharsets.UTF_8), scriptUrlAsString);){
                    if (scriptEngine instanceof Compilable) {
                        Compilable compilableScriptEngine = (Compilable)((Object)scriptEngine);
                        CompiledScript compiledScript = compilableScriptEngine.compile((Reader)reader);
                        ProviderOutcome providerOutcome = ProviderOutcome.notNullOrFailure((Object)compiledScript.eval(bindings));
                        return providerOutcome;
                    }
                    ProviderOutcome providerOutcome = ProviderOutcome.notNullOrFailure((Object)scriptEngine.eval((Reader)reader, bindings));
                    return providerOutcome;
                }
                catch (Exception e) {
                    return ProviderOutcome.failure((Throwable)e);
                }
            }
        }
        if ((scriptResource = this.scriptDependencyResolver.resolveScript(renderContext, scriptName)) != null) return this.evalScript(scriptResource, bindings);
        log.debug("Path does not match an existing resource: {}", (Object)scriptName);
        return ProviderOutcome.failure();
    }

    private ProviderOutcome evalScript(Resource scriptResource, Bindings bindings) {
        SlingScript slingScript = (SlingScript)scriptResource.adaptTo(SlingScript.class);
        if (slingScript == null) {
            return ProviderOutcome.failure();
        }
        SlingBindings slingBindings = new SlingBindings();
        slingBindings.putAll((Map)bindings);
        Object scriptEval = slingScript.eval(slingBindings);
        return ProviderOutcome.notNullOrFailure((Object)scriptEval);
    }

    private String scriptExtension(String path) {
        String extension = StringUtils.substringAfterLast((String)path, (String)".");
        if (StringUtils.isEmpty((CharSequence)extension)) {
            extension = null;
        }
        return extension;
    }

    @Nullable
    private ScriptEngineManager getScriptEngineManager() {
        ScriptEngineManager result = this.engineManagerRef.get();
        if (result == null) {
            ServiceReference ref = this.bundleContext.getServiceReference(ScriptEngineManager.class);
            if (ref != null) {
                ScriptEngineManager mgr = (ScriptEngineManager)this.bundleContext.getService(ref);
                if (mgr != null && this.engineManagerRef.compareAndSet(null, mgr)) {
                    this.scriptEngineManagerServiceReference = ref;
                    return mgr;
                }
                if (mgr != null) {
                    this.bundleContext.ungetService(ref);
                }
            }
            return null;
        }
        return result;
    }

    static @interface Configuration {
        @AttributeDefinition(name="Service Ranking", description="The Service Ranking value acts as the priority with which this Use Provider is queried to return an Use-object. A higher value represents a higher priority.")
        public int service_ranking() default 0;
    }
}

