/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.starter.access.models;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;

public class AceUtils {
    private AceUtils() {
    }

    private static void toLongestPath(String prefix, Privilege parentPrivilege, Map<Privilege, String> privilegeToLongestPath) {
        Privilege[] declaredAggregatePrivileges;
        for (Privilege privilege : declaredAggregatePrivileges = parentPrivilege.getDeclaredAggregatePrivileges()) {
            String candidatePath = String.format("%s/%s", prefix, privilege.getName());
            String oldValue = privilegeToLongestPath.get(privilege);
            if (oldValue != null && oldValue.length() >= candidatePath.length()) continue;
            privilegeToLongestPath.put(privilege, candidatePath);
            AceUtils.toLongestPath(candidatePath, privilege, privilegeToLongestPath);
        }
    }

    public static Map<Privilege, String> getPrivilegeLongestPathMap(Session jcrSession) throws RepositoryException {
        AccessControlManager accessControlManager = jcrSession.getAccessControlManager();
        Privilege jcrAll = accessControlManager.privilegeFromName("jcr:all");
        HashMap<Privilege, String> privilegeToLongestPath = new HashMap<Privilege, String>();
        privilegeToLongestPath.put(jcrAll, jcrAll.getName());
        AceUtils.toLongestPath(jcrAll.getName(), jcrAll, privilegeToLongestPath);
        return privilegeToLongestPath;
    }
}

