/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.starter.testservices.servlets;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.felix.utils.json.JSONWriter;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Servlet.class}, property={"service.description:String=GetConfig Test Servlet", "service.vendor:String=The Apache Software Foundation", "sling.servlet.paths:String=/testing/GetConfigServlet", "sling.servlet.extensions:String=json"})
public class GetConfigServlet
extends SlingSafeMethodsServlet {
    @Reference
    private ConfigurationAdmin configAdmin;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        Configuration cfg;
        Dictionary props;
        String pid = request.getRequestPathInfo().getSuffix();
        if (pid == null || pid.length() == 0) {
            throw new ServletException("Configuration PID must be provided in request suffix");
        }
        if (pid.startsWith("/")) {
            pid = pid.substring(1);
        }
        if ((props = (cfg = this.getUniqueConfig(pid)).getProperties()) == null) {
            response.sendError(404, "Properties of config with pid=" + pid + " not found");
            return;
        }
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        Enumeration keys = props.keys();
        try {
            JSONWriter w = new JSONWriter(response.getWriter());
            w.object();
            w.key("source").value(((Object)((Object)this)).getClass().getName());
            w.key("pid").value(pid);
            w.key("properties");
            w.object();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                Object value = props.get(key);
                if (value == null) continue;
                w.key(key.toString()).value(value.toString());
            }
            w.endObject();
            w.endObject();
            w.flush();
        }
        catch (IOException je) {
            throw (IOException)new IOException("JSONException in doGet").initCause(je);
        }
    }

    private Configuration getUniqueConfig(String pid) throws ServletException {
        String filter = "(service.pid=" + pid + ")";
        Configuration[] cfg = null;
        try {
            cfg = this.configAdmin.listConfigurations(filter);
        }
        catch (Exception e) {
            throw new ServletException("Error listing configs with filter " + filter, (Throwable)e);
        }
        if (cfg == null) {
            throw new ServletException("No config found with filter " + filter);
        }
        if (cfg.length > 1) {
            throw new ServletException("Expected 1 config, found " + cfg.length + " with filter " + filter);
        }
        return cfg[0];
    }
}

