/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.version;

import java.util.Objects;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.jetbrains.annotations.NotNull;

public class VersionStorage {
    public static final String VERSION_STORAGE_PATH = "/jcr:system/jcr:versionStorage";
    private final Root root;

    public VersionStorage(@NotNull Root versionStorageRoot) {
        this.root = versionStorageRoot;
    }

    Root getRoot() {
        return this.root;
    }

    Tree getTree() {
        return VersionStorage.getVersionStorageTree(this.root);
    }

    void refresh() {
        this.root.refresh();
    }

    private static Tree getVersionStorageTree(@NotNull Root workspaceRoot) {
        return Objects.requireNonNull(workspaceRoot).getTree(VERSION_STORAGE_PATH);
    }
}

