/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.stat;

import java.io.Serializable;
import java.util.Map;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.stat.MultiClassSummarizer;
import org.apache.spark.ml.stat.SummarizerBuffer;
import org.apache.spark.ml.stat.SummaryBuilder;
import org.apache.spark.ml.stat.SummaryBuilderImpl;
import org.apache.spark.ml.stat.SummaryBuilderImpl$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.functions$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class Summarizer$
implements Logging {
    public static final Summarizer$ MODULE$ = new Summarizer$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SummaryBuilder metrics(String ... metrics) {
        return this.metrics((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])metrics));
    }

    public SummaryBuilder metrics(Seq<String> metrics) {
        Predef$.MODULE$.require(metrics.nonEmpty(), (Function0 & Serializable)() -> "Should include at least one metric");
        Tuple2<Seq<SummaryBuilderImpl.Metric>, Seq<SummaryBuilderImpl.ComputeMetric>> tuple2 = SummaryBuilderImpl$.MODULE$.getRelevantMetrics(metrics);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq typedMetrics = (Seq)tuple2._1();
        Seq computeMetrics = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)typedMetrics, (Object)computeMetrics);
        Seq typedMetrics2 = (Seq)tuple22._1();
        Seq computeMetrics2 = (Seq)tuple22._2();
        return new SummaryBuilderImpl((Seq<SummaryBuilderImpl.Metric>)typedMetrics2, (Seq<SummaryBuilderImpl.ComputeMetric>)computeMetrics2);
    }

    public Column mean(Column col, Column weightCol) {
        return this.getSingleMetric(col, weightCol, "mean");
    }

    public Column mean(Column col) {
        return this.mean(col, functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)1.0)));
    }

    public Column sum(Column col, Column weightCol) {
        return this.getSingleMetric(col, weightCol, "sum");
    }

    public Column sum(Column col) {
        return this.sum(col, functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)1.0)));
    }

    public Column variance(Column col, Column weightCol) {
        return this.getSingleMetric(col, weightCol, "variance");
    }

    public Column variance(Column col) {
        return this.variance(col, functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)1.0)));
    }

    public Column std(Column col, Column weightCol) {
        return this.getSingleMetric(col, weightCol, "std");
    }

    public Column std(Column col) {
        return this.std(col, functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)1.0)));
    }

    public Column count(Column col, Column weightCol) {
        return this.getSingleMetric(col, weightCol, "count");
    }

    public Column count(Column col) {
        return this.count(col, functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)1.0)));
    }

    public Column numNonZeros(Column col, Column weightCol) {
        return this.getSingleMetric(col, weightCol, "numNonZeros");
    }

    public Column numNonZeros(Column col) {
        return this.numNonZeros(col, functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)1.0)));
    }

    public Column max(Column col, Column weightCol) {
        return this.getSingleMetric(col, weightCol, "max");
    }

    public Column max(Column col) {
        return this.max(col, functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)1.0)));
    }

    public Column min(Column col, Column weightCol) {
        return this.getSingleMetric(col, weightCol, "min");
    }

    public Column min(Column col) {
        return this.min(col, functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)1.0)));
    }

    public Column normL1(Column col, Column weightCol) {
        return this.getSingleMetric(col, weightCol, "normL1");
    }

    public Column normL1(Column col) {
        return this.normL1(col, functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)1.0)));
    }

    public Column normL2(Column col, Column weightCol) {
        return this.getSingleMetric(col, weightCol, "normL2");
    }

    public Column normL2(Column col) {
        return this.normL2(col, functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)1.0)));
    }

    private Column getSingleMetric(Column col, Column weightCol, String metric) {
        Column c1 = this.metrics((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{metric})).summary(col, weightCol);
        return c1.getField(metric).as(metric + "(" + col + ")");
    }

    public SummarizerBuffer createSummarizerBuffer(Seq<String> requested) {
        Tuple2<Seq<SummaryBuilderImpl.Metric>, Seq<SummaryBuilderImpl.ComputeMetric>> tuple2 = SummaryBuilderImpl$.MODULE$.getRelevantMetrics(requested);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq metrics = (Seq)tuple2._1();
        Seq computeMetrics = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)metrics, (Object)computeMetrics);
        Seq metrics2 = (Seq)tuple22._1();
        Seq computeMetrics2 = (Seq)tuple22._2();
        return new SummarizerBuffer((Seq<SummaryBuilderImpl.Metric>)metrics2, (Seq<SummaryBuilderImpl.ComputeMetric>)computeMetrics2);
    }

    public Tuple2<SummarizerBuffer, SummarizerBuffer> getRegressionSummarizers(RDD<Instance> instances, int aggregationDepth, Seq<String> requested) {
        return (Tuple2)instances.treeAggregate((Object)new Tuple2((Object)this.createSummarizerBuffer(requested), (Object)this.createSummarizerBuffer((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"mean", "std", "count"}))), (Function2 & Serializable)(c, instance) -> new Tuple2((Object)((SummarizerBuffer)c._1()).add(instance.features(), instance.weight()), (Object)((SummarizerBuffer)c._2()).add(Vectors$.MODULE$.dense(instance.label(), (Seq)Nil$.MODULE$), instance.weight())), (Function2 & Serializable)(c1, c2) -> new Tuple2((Object)((SummarizerBuffer)c1._1()).merge((SummarizerBuffer)c2._1()), (Object)((SummarizerBuffer)c1._2()).merge((SummarizerBuffer)c2._2())), aggregationDepth, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public int getRegressionSummarizers$default$2() {
        return 2;
    }

    public Seq<String> getRegressionSummarizers$default$3() {
        return new .colon.colon((Object)"mean", (List)new .colon.colon((Object)"std", (List)new .colon.colon((Object)"count", (List)Nil$.MODULE$)));
    }

    public Tuple2<SummarizerBuffer, MultiClassSummarizer> getClassificationSummarizers(RDD<Instance> instances, int aggregationDepth, Seq<String> requested) {
        return (Tuple2)instances.treeAggregate((Object)new Tuple2((Object)this.createSummarizerBuffer(requested), (Object)new MultiClassSummarizer()), (Function2 & Serializable)(c, instance) -> new Tuple2((Object)((SummarizerBuffer)c._1()).add(instance.features(), instance.weight()), (Object)((MultiClassSummarizer)c._2()).add(instance.label(), instance.weight())), (Function2 & Serializable)(c1, c2) -> new Tuple2((Object)((SummarizerBuffer)c1._1()).merge((SummarizerBuffer)c2._1()), (Object)((MultiClassSummarizer)c1._2()).merge((MultiClassSummarizer)c2._2())), aggregationDepth, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public int getClassificationSummarizers$default$2() {
        return 2;
    }

    public Seq<String> getClassificationSummarizers$default$3() {
        return new .colon.colon((Object)"mean", (List)new .colon.colon((Object)"std", (List)new .colon.colon((Object)"count", (List)Nil$.MODULE$)));
    }

    private Summarizer$() {
    }
}

