/*
 * Decompiled with CFR 0.152.
 */
package org.json4s;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.json4s.ParserUtil$;
import org.json4s.Segment;
import org.json4s.Segments;
import scala.Option;
import scala.Some;
import scala.runtime.BoxedUnit;
import scala.sys.package$;

public final class Segments$ {
    public static final Segments$ MODULE$ = new Segments$();
    private static final boolean enableSegments;
    private static int segmentSize;
    private static final int maxNumOfSegments;
    private static final AtomicInteger segmentCount;
    private static final ArrayBlockingQueue<Segment> segments;

    static {
        Option option = package$.MODULE$.props().get("json4s.segments.enable");
        Some some = new Some((Object)"false");
        enableSegments = option == null ? some != null : !option.equals(some);
        segmentSize = ParserUtil$.MODULE$.defaultSegmentSize();
        maxNumOfSegments = 10000;
        segmentCount = new AtomicInteger(0);
        segments = new ArrayBlockingQueue(maxNumOfSegments);
    }

    public int segmentSize() {
        return segmentSize;
    }

    public void segmentSize_$eq(int x$1) {
        segmentSize = x$1;
    }

    public void clear() {
        segments.clear();
    }

    public Segment apply() {
        Segment s;
        return enableSegments ? ((s = this.acquire()) != null ? s : new Segments.DisposableSegment(new char[this.segmentSize()])) : new Segments.DisposableSegment(new char[this.segmentSize()]);
    }

    private Segment acquire() {
        int curCount = segmentCount.get();
        boolean createNew = segments.size() == 0 && curCount < maxNumOfSegments ? segmentCount.compareAndSet(curCount, curCount + 1) : false;
        return createNew ? new Segments.RecycledSegment(new char[this.segmentSize()]) : segments.poll();
    }

    public void release(Segment s) {
        Segment segment = s;
        if (segment instanceof Segments.RecycledSegment) {
            segments.offer(s);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private Segments$() {
    }
}

