/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.service.CompositeService;
import org.apache.hive.service.ServiceException;
import org.apache.hive.service.auth.HiveAuthFactory;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.FetchType;
import org.apache.hive.service.cli.GetInfoType;
import org.apache.hive.service.cli.GetInfoValue;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.ICLIService;
import org.apache.hive.service.cli.OperationHandle;
import org.apache.hive.service.cli.OperationStatus;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.operation.Operation;
import org.apache.hive.service.cli.session.HiveSession;
import org.apache.hive.service.cli.session.SessionManager;
import org.apache.hive.service.rpc.thrift.TOperationHandle;
import org.apache.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.hive.service.rpc.thrift.TRowSet;
import org.apache.hive.service.rpc.thrift.TTableSchema;
import org.apache.hive.service.server.HiveServer2;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.SparkLogger;
import org.apache.spark.internal.SparkLoggerFactory;

public class CLIService
extends CompositeService
implements ICLIService {
    private static final SparkLogger LOG = SparkLoggerFactory.getLogger(CLIService.class);
    public static final TProtocolVersion SERVER_VERSION;
    private HiveConf hiveConf;
    private SessionManager sessionManager;
    private UserGroupInformation serviceUGI;
    private UserGroupInformation httpUGI;
    private final HiveServer2 hiveServer2;

    public CLIService(HiveServer2 hiveServer2) {
        super(CLIService.class.getSimpleName());
        this.hiveServer2 = hiveServer2;
    }

    @Override
    public synchronized void init(HiveConf hiveConf) {
        this.hiveConf = hiveConf;
        this.sessionManager = new SessionManager(this.hiveServer2);
        this.addService(this.sessionManager);
        if (UserGroupInformation.isSecurityEnabled()) {
            try {
                HiveAuthFactory.loginFromKeytab(hiveConf);
                this.serviceUGI = Utils.getUGI();
            }
            catch (IOException e) {
                throw new ServiceException("Unable to login to kerberos with given principal/keytab", e);
            }
            catch (LoginException e) {
                throw new ServiceException("Unable to login to kerberos with given principal/keytab", e);
            }
            String principal = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_SPNEGO_PRINCIPAL);
            String keyTabFile = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_SPNEGO_KEYTAB);
            if (principal.isEmpty() || keyTabFile.isEmpty()) {
                LOG.info("SPNego httpUGI not created, spNegoPrincipal: {}, keytabFile: {}", new MDC[]{MDC.of((LogKey)LogKeys.PRINCIPAL$.MODULE$, (Object)principal), MDC.of((LogKey)LogKeys.KEYTAB_FILE$.MODULE$, (Object)keyTabFile)});
            } else {
                try {
                    this.httpUGI = HiveAuthFactory.loginFromSpnegoKeytabAndReturnUGI(hiveConf);
                    LOG.info("SPNego httpUGI successfully created.");
                }
                catch (IOException e) {
                    LOG.warn("SPNego httpUGI creation failed: ", (Throwable)e);
                }
            }
        }
        try {
            this.applyAuthorizationConfigPolicy(hiveConf);
        }
        catch (Exception e) {
            throw new RuntimeException("Error applying authorization policy on hive configuration: " + e.getMessage(), e);
        }
        this.setupBlockedUdfs();
        super.init(hiveConf);
    }

    private void applyAuthorizationConfigPolicy(HiveConf newHiveConf) throws HiveException, MetaException {
        SessionState ss = new SessionState(newHiveConf);
        ss.setIsHiveServerQuery(true);
        SessionState.start((SessionState)ss);
        ss.applyAuthorizationPolicy();
    }

    private void setupBlockedUdfs() {
        FunctionRegistry.setupPermissionsForBuiltinUDFs((String)this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_BUILTIN_UDF_WHITELIST), (String)this.hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_BUILTIN_UDF_BLACKLIST));
    }

    public UserGroupInformation getServiceUGI() {
        return this.serviceUGI;
    }

    public UserGroupInformation getHttpUGI() {
        return this.httpUGI;
    }

    @Override
    public synchronized void start() {
        super.start();
        try (HiveMetaStoreClient metastoreClient = null;){
            metastoreClient = new HiveMetaStoreClient(this.hiveConf);
            metastoreClient.getDatabases("default");
        }
    }

    @Override
    public synchronized void stop() {
        super.stop();
    }

    @Deprecated
    public SessionHandle openSession(TProtocolVersion protocol, String username, String password, Map<String, String> configuration) throws HiveSQLException {
        SessionHandle sessionHandle = this.sessionManager.openSession(protocol, username, password, null, configuration, false, null);
        LOG.debug(String.valueOf(sessionHandle) + ": openSession()");
        return sessionHandle;
    }

    @Deprecated
    public SessionHandle openSessionWithImpersonation(TProtocolVersion protocol, String username, String password, Map<String, String> configuration, String delegationToken) throws HiveSQLException {
        SessionHandle sessionHandle = this.sessionManager.openSession(protocol, username, password, null, configuration, true, delegationToken);
        LOG.debug(String.valueOf(sessionHandle) + ": openSessionWithImpersonation()");
        return sessionHandle;
    }

    public SessionHandle openSession(TProtocolVersion protocol, String username, String password, String ipAddress, Map<String, String> configuration) throws HiveSQLException {
        SessionHandle sessionHandle = this.sessionManager.openSession(protocol, username, password, ipAddress, configuration, false, null);
        LOG.debug(String.valueOf(sessionHandle) + ": openSession()");
        return sessionHandle;
    }

    public SessionHandle openSessionWithImpersonation(TProtocolVersion protocol, String username, String password, String ipAddress, Map<String, String> configuration, String delegationToken) throws HiveSQLException {
        SessionHandle sessionHandle = this.sessionManager.openSession(protocol, username, password, ipAddress, configuration, true, delegationToken);
        LOG.debug(String.valueOf(sessionHandle) + ": openSession()");
        return sessionHandle;
    }

    @Override
    public SessionHandle openSession(String username, String password, Map<String, String> configuration) throws HiveSQLException {
        SessionHandle sessionHandle = this.sessionManager.openSession(SERVER_VERSION, username, password, null, configuration, false, null);
        LOG.debug(String.valueOf(sessionHandle) + ": openSession()");
        return sessionHandle;
    }

    @Override
    public SessionHandle openSessionWithImpersonation(String username, String password, Map<String, String> configuration, String delegationToken) throws HiveSQLException {
        SessionHandle sessionHandle = this.sessionManager.openSession(SERVER_VERSION, username, password, null, configuration, true, delegationToken);
        LOG.debug(String.valueOf(sessionHandle) + ": openSession()");
        return sessionHandle;
    }

    @Override
    public void closeSession(SessionHandle sessionHandle) throws HiveSQLException {
        this.sessionManager.closeSession(sessionHandle);
        LOG.debug(String.valueOf(sessionHandle) + ": closeSession()");
    }

    @Override
    public GetInfoValue getInfo(SessionHandle sessionHandle, GetInfoType getInfoType) throws HiveSQLException {
        GetInfoValue infoValue = this.sessionManager.getSession(sessionHandle).getInfo(getInfoType);
        LOG.debug(String.valueOf(sessionHandle) + ": getInfo()");
        return infoValue;
    }

    @Override
    public OperationHandle executeStatement(SessionHandle sessionHandle, String statement, Map<String, String> confOverlay) throws HiveSQLException {
        HiveSession session = this.sessionManager.getSession(sessionHandle);
        session.getSessionState().updateProgressMonitor(null);
        OperationHandle opHandle = session.executeStatement(statement, confOverlay);
        LOG.debug(String.valueOf(sessionHandle) + ": executeStatement()");
        return opHandle;
    }

    @Override
    public OperationHandle executeStatement(SessionHandle sessionHandle, String statement, Map<String, String> confOverlay, long queryTimeout) throws HiveSQLException {
        HiveSession session = this.sessionManager.getSession(sessionHandle);
        session.getSessionState().updateProgressMonitor(null);
        OperationHandle opHandle = session.executeStatement(statement, confOverlay, queryTimeout);
        LOG.debug(String.valueOf(sessionHandle) + ": executeStatement()");
        return opHandle;
    }

    @Override
    public OperationHandle executeStatementAsync(SessionHandle sessionHandle, String statement, Map<String, String> confOverlay) throws HiveSQLException {
        HiveSession session = this.sessionManager.getSession(sessionHandle);
        session.getSessionState().updateProgressMonitor(null);
        OperationHandle opHandle = session.executeStatementAsync(statement, confOverlay);
        LOG.debug(String.valueOf(sessionHandle) + ": executeStatementAsync()");
        return opHandle;
    }

    @Override
    public OperationHandle executeStatementAsync(SessionHandle sessionHandle, String statement, Map<String, String> confOverlay, long queryTimeout) throws HiveSQLException {
        HiveSession session = this.sessionManager.getSession(sessionHandle);
        session.getSessionState().updateProgressMonitor(null);
        OperationHandle opHandle = session.executeStatementAsync(statement, confOverlay, queryTimeout);
        LOG.debug(String.valueOf(sessionHandle) + ": executeStatementAsync()");
        return opHandle;
    }

    @Override
    public OperationHandle getTypeInfo(SessionHandle sessionHandle) throws HiveSQLException {
        OperationHandle opHandle = this.sessionManager.getSession(sessionHandle).getTypeInfo();
        LOG.debug(String.valueOf(sessionHandle) + ": getTypeInfo()");
        return opHandle;
    }

    @Override
    public OperationHandle getCatalogs(SessionHandle sessionHandle) throws HiveSQLException {
        OperationHandle opHandle = this.sessionManager.getSession(sessionHandle).getCatalogs();
        LOG.debug(String.valueOf(sessionHandle) + ": getCatalogs()");
        return opHandle;
    }

    @Override
    public OperationHandle getSchemas(SessionHandle sessionHandle, String catalogName, String schemaName) throws HiveSQLException {
        OperationHandle opHandle = this.sessionManager.getSession(sessionHandle).getSchemas(catalogName, schemaName);
        LOG.debug(String.valueOf(sessionHandle) + ": getSchemas()");
        return opHandle;
    }

    @Override
    public OperationHandle getTables(SessionHandle sessionHandle, String catalogName, String schemaName, String tableName, List<String> tableTypes) throws HiveSQLException {
        OperationHandle opHandle = this.sessionManager.getSession(sessionHandle).getTables(catalogName, schemaName, tableName, tableTypes);
        LOG.debug(String.valueOf(sessionHandle) + ": getTables()");
        return opHandle;
    }

    @Override
    public OperationHandle getTableTypes(SessionHandle sessionHandle) throws HiveSQLException {
        OperationHandle opHandle = this.sessionManager.getSession(sessionHandle).getTableTypes();
        LOG.debug(String.valueOf(sessionHandle) + ": getTableTypes()");
        return opHandle;
    }

    @Override
    public OperationHandle getColumns(SessionHandle sessionHandle, String catalogName, String schemaName, String tableName, String columnName) throws HiveSQLException {
        OperationHandle opHandle = this.sessionManager.getSession(sessionHandle).getColumns(catalogName, schemaName, tableName, columnName);
        LOG.debug(String.valueOf(sessionHandle) + ": getColumns()");
        return opHandle;
    }

    @Override
    public OperationHandle getFunctions(SessionHandle sessionHandle, String catalogName, String schemaName, String functionName) throws HiveSQLException {
        OperationHandle opHandle = this.sessionManager.getSession(sessionHandle).getFunctions(catalogName, schemaName, functionName);
        LOG.debug(String.valueOf(sessionHandle) + ": getFunctions()");
        return opHandle;
    }

    @Override
    public OperationHandle getPrimaryKeys(SessionHandle sessionHandle, String catalog, String schema, String table) throws HiveSQLException {
        OperationHandle opHandle = this.sessionManager.getSession(sessionHandle).getPrimaryKeys(catalog, schema, table);
        LOG.debug(String.valueOf(sessionHandle) + ": getPrimaryKeys()");
        return opHandle;
    }

    @Override
    public OperationHandle getCrossReference(SessionHandle sessionHandle, String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws HiveSQLException {
        OperationHandle opHandle = this.sessionManager.getSession(sessionHandle).getCrossReference(primaryCatalog, primarySchema, primaryTable, foreignCatalog, foreignSchema, foreignTable);
        LOG.debug(String.valueOf(sessionHandle) + ": getCrossReference()");
        return opHandle;
    }

    @Override
    public OperationStatus getOperationStatus(OperationHandle opHandle) throws HiveSQLException {
        Operation operation = this.sessionManager.getOperationManager().getOperation(opHandle);
        if (operation.shouldRunAsync()) {
            HiveConf conf = operation.getParentSession().getHiveConf();
            long timeout = HiveConf.getTimeVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_LONG_POLLING_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS);
            try {
                operation.getBackgroundHandle().get(timeout, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                LOG.trace(String.valueOf(opHandle) + ": Long polling timed out");
            }
            catch (CancellationException e) {
                LOG.trace(String.valueOf(opHandle) + ": The background operation was cancelled", (Throwable)e);
            }
            catch (ExecutionException e) {
                LOG.warn("{}: The background operation was aborted", (Throwable)e, new MDC[]{MDC.of((LogKey)LogKeys.OPERATION_HANDLE$.MODULE$, (Object)opHandle)});
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        OperationStatus opStatus = operation.getStatus();
        LOG.debug(String.valueOf(opHandle) + ": getOperationStatus()");
        return opStatus;
    }

    public HiveConf getSessionConf(SessionHandle sessionHandle) throws HiveSQLException {
        return this.sessionManager.getSession(sessionHandle).getHiveConf();
    }

    @Override
    public void cancelOperation(OperationHandle opHandle) throws HiveSQLException {
        this.sessionManager.getOperationManager().getOperation(opHandle).getParentSession().cancelOperation(opHandle);
        LOG.debug(String.valueOf(opHandle) + ": cancelOperation()");
    }

    @Override
    public void closeOperation(OperationHandle opHandle) throws HiveSQLException {
        this.sessionManager.getOperationManager().getOperation(opHandle).getParentSession().closeOperation(opHandle);
        LOG.debug(String.valueOf(opHandle) + ": closeOperation");
    }

    @Override
    public TTableSchema getResultSetMetadata(OperationHandle opHandle) throws HiveSQLException {
        TTableSchema tableSchema = this.sessionManager.getOperationManager().getOperation(opHandle).getParentSession().getResultSetMetadata(opHandle);
        LOG.debug(String.valueOf(opHandle) + ": getResultSetMetadata()");
        return tableSchema;
    }

    @Override
    public TRowSet fetchResults(OperationHandle opHandle) throws HiveSQLException {
        return this.fetchResults(opHandle, Operation.DEFAULT_FETCH_ORIENTATION, 100L, FetchType.QUERY_OUTPUT);
    }

    @Override
    public TRowSet fetchResults(OperationHandle opHandle, FetchOrientation orientation, long maxRows, FetchType fetchType) throws HiveSQLException {
        TRowSet rowSet = this.sessionManager.getOperationManager().getOperation(opHandle).getParentSession().fetchResults(opHandle, orientation, maxRows, fetchType);
        LOG.debug(String.valueOf(opHandle) + ": fetchResults()");
        return rowSet;
    }

    public synchronized String getDelegationTokenFromMetaStore(String owner) throws HiveSQLException, UnsupportedOperationException, LoginException, IOException {
        if (!this.hiveConf.getBoolVar(HiveConf.ConfVars.METASTORE_USE_THRIFT_SASL) || !this.hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS)) {
            throw new UnsupportedOperationException("delegation token is can only be obtained for a secure remote metastore");
        }
        try {
            Hive.closeCurrent();
            return Hive.getWithoutRegisterFns((HiveConf)this.hiveConf).getDelegationToken(owner, owner);
        }
        catch (HiveException e) {
            if (e.getCause() instanceof UnsupportedOperationException) {
                throw (UnsupportedOperationException)e.getCause();
            }
            throw new HiveSQLException("Error connect metastore to setup impersonation", e);
        }
    }

    @Override
    public String getDelegationToken(SessionHandle sessionHandle, HiveAuthFactory authFactory, String owner, String renewer) throws HiveSQLException {
        String delegationToken = this.sessionManager.getSession(sessionHandle).getDelegationToken(authFactory, owner, renewer);
        LOG.info("{}: getDelegationToken()", new MDC[]{MDC.of((LogKey)LogKeys.SESSION_HANDLE$.MODULE$, (Object)sessionHandle)});
        return delegationToken;
    }

    @Override
    public void cancelDelegationToken(SessionHandle sessionHandle, HiveAuthFactory authFactory, String tokenStr) throws HiveSQLException {
        this.sessionManager.getSession(sessionHandle).cancelDelegationToken(authFactory, tokenStr);
        LOG.info("{}: cancelDelegationToken()", new MDC[]{MDC.of((LogKey)LogKeys.SESSION_HANDLE$.MODULE$, (Object)sessionHandle)});
    }

    @Override
    public void renewDelegationToken(SessionHandle sessionHandle, HiveAuthFactory authFactory, String tokenStr) throws HiveSQLException {
        this.sessionManager.getSession(sessionHandle).renewDelegationToken(authFactory, tokenStr);
        LOG.info("{}: renewDelegationToken()", new MDC[]{MDC.of((LogKey)LogKeys.SESSION_HANDLE$.MODULE$, (Object)sessionHandle)});
    }

    @Override
    public String getQueryId(TOperationHandle opHandle) throws HiveSQLException {
        Operation operation = this.sessionManager.getOperationManager().getOperation(new OperationHandle(opHandle));
        String queryId = operation.getParentSession().getHiveConf().getVar(HiveConf.getConfVars((String)"hive.query.id"));
        LOG.debug(String.valueOf(opHandle) + ": getQueryId() " + queryId);
        return queryId;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    static {
        TProtocolVersion[] protocols = TProtocolVersion.values();
        SERVER_VERSION = protocols[protocols.length - 1];
    }
}

