/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.execution.streaming.CompositeKeyStateEncoder;
import org.apache.spark.sql.execution.streaming.CompositeKeyStateEncoder$;
import org.apache.spark.sql.execution.streaming.MapStateImpl$;
import org.apache.spark.sql.execution.streaming.TWSMetricsUtils$;
import org.apache.spark.sql.execution.streaming.TransformWithStateKeyValueRowSchemaUtils$;
import org.apache.spark.sql.execution.streaming.state.PrefixKeyScanStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.StateStore;
import org.apache.spark.sql.execution.streaming.state.StateStoreErrors$;
import org.apache.spark.sql.execution.streaming.state.StateStoreIterator;
import org.apache.spark.sql.execution.streaming.state.UnsafeRowPair;
import org.apache.spark.sql.streaming.MapState;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005uf\u0001\u0002\u000f\u001e\u0001)B\u0001b\u0013\u0001\u0003\u0002\u0003\u0006I\u0001\u0014\u0005\t%\u0002\u0011\t\u0011)A\u0005'\"Aa\f\u0001B\u0001B\u0003%q\f\u0003\u0005h\u0001\t\u0005\t\u0015!\u0003`\u0011!A\u0007A!A!\u0002\u0013y\u0006\u0002C5\u0001\u0005\u0003\u0005\u000b\u0011\u00026\t\u000bM\u0004A\u0011\u0001;\t\u000fu\u0004!\u0019!C\u0005}\"9\u00111\u0002\u0001!\u0002\u0013y\b\u0002CA\u0007\u0001\t\u0007I\u0011\u0002@\t\u000f\u0005=\u0001\u0001)A\u0005\u007f\"I\u0011\u0011\u0003\u0001C\u0002\u0013%\u00111\u0003\u0005\t\u00037\u0001\u0001\u0015!\u0003\u0002\u0016!9\u0011Q\u0004\u0001\u0005B\u0005}\u0001bBA\u0014\u0001\u0011\u0005\u0013\u0011\u0006\u0005\b\u0003_\u0001A\u0011IA\u0019\u0011\u001d\t)\u0004\u0001C!\u0003oAq!!\u0012\u0001\t\u0003\n9\u0005C\u0004\u0002b\u0001!\t%a\u0019\t\u000f\u0005\u001d\u0004\u0001\"\u0011\u0002j!9\u0011Q\u000e\u0001\u0005B\u0005=\u0004bBA:\u0001\u0011\u0005\u0013QO\u0004\n\u0003oj\u0012\u0011!E\u0001\u0003s2\u0001\u0002H\u000f\u0002\u0002#\u0005\u00111\u0010\u0005\u0007gb!\t!!$\t\u0013\u0005=\u0005$%A\u0005\u0002\u0005E\u0005\"CAW1\u0005\u0005I\u0011BAX\u00051i\u0015\r]*uCR,\u0017*\u001c9m\u0015\tqr$A\u0005tiJ,\u0017-\\5oO*\u0011\u0001%I\u0001\nKb,7-\u001e;j_:T!AI\u0012\u0002\u0007M\fHN\u0003\u0002%K\u0005)1\u000f]1sW*\u0011aeJ\u0001\u0007CB\f7\r[3\u000b\u0003!\n1a\u001c:h\u0007\u0001)2aK\u001dD'\u0011\u0001AFM#\u0011\u00055\u0002T\"\u0001\u0018\u000b\u0003=\nQa]2bY\u0006L!!\r\u0018\u0003\r\u0005s\u0017PU3g!\u0011\u0019Tg\u000e\"\u000e\u0003QR!AH\u0011\n\u0005Y\"$\u0001C'baN#\u0018\r^3\u0011\u0005aJD\u0002\u0001\u0003\u0006u\u0001\u0011\ra\u000f\u0002\u0002\u0017F\u0011Ah\u0010\t\u0003[uJ!A\u0010\u0018\u0003\u000f9{G\u000f[5oOB\u0011Q\u0006Q\u0005\u0003\u0003:\u00121!\u00118z!\tA4\tB\u0003E\u0001\t\u00071HA\u0001W!\t1\u0015*D\u0001H\u0015\tA5%\u0001\u0005j]R,'O\\1m\u0013\tQuIA\u0004M_\u001e<\u0017N\\4\u0002\u000bM$xN]3\u0011\u00055\u0003V\"\u0001(\u000b\u0005=k\u0012!B:uCR,\u0017BA)O\u0005)\u0019F/\u0019;f'R|'/Z\u0001\ngR\fG/\u001a(b[\u0016\u0004\"\u0001V.\u000f\u0005UK\u0006C\u0001,/\u001b\u00059&B\u0001-*\u0003\u0019a$o\\8u}%\u0011!LL\u0001\u0007!J,G-\u001a4\n\u0005qk&AB*ue&twM\u0003\u0002[]\u0005Q1.Z=FqB\u0014XI\\2\u0011\u0007\u0001,w(D\u0001b\u0015\t\u00117-\u0001\u0005f]\u000e|G-\u001a:t\u0015\t!\u0017%\u0001\u0005dCR\fG._:u\u0013\t1\u0017MA\tFqB\u0014Xm]:j_:,enY8eKJ\f!\"^:fe.+\u00170\u00128d\u0003)1\u0018\r\\#oG>$WM]\u0001\b[\u0016$(/[2t!\u0011!6nU7\n\u00051l&aA'baB\u0011a.]\u0007\u0002_*\u0011\u0001oH\u0001\u0007[\u0016$(/[2\n\u0005I|'!C*R\u00196+GO]5d\u0003\u0019a\u0014N\\5u}Q9Qo\u001e=zund\b\u0003\u0002<\u0001o\tk\u0011!\b\u0005\u0006\u0017\u001e\u0001\r\u0001\u0014\u0005\u0006%\u001e\u0001\ra\u0015\u0005\u0006=\u001e\u0001\ra\u0018\u0005\u0006O\u001e\u0001\ra\u0018\u0005\u0006Q\u001e\u0001\ra\u0018\u0005\bS\u001e\u0001\n\u00111\u0001k\u0003a\u00198\r[3nC\u001a{'oQ8na>\u001c\u0018\u000e^3LKf\u0014vn^\u000b\u0002\u007fB!\u0011\u0011AA\u0004\u001b\t\t\u0019AC\u0002\u0002\u0006\u0005\nQ\u0001^=qKNLA!!\u0003\u0002\u0004\tQ1\u000b\u001e:vGR$\u0016\u0010]3\u00023M\u001c\u0007.Z7b\r>\u00148i\\7q_NLG/Z&fsJ{w\u000fI\u0001\u0012g\u000eDW-\\1G_J4\u0016\r\\;f%><\u0018AE:dQ\u0016l\u0017MR8s-\u0006dW/\u001a*po\u0002\n\u0011c\u001d;bi\u0016$\u0016\u0010]3t\u000b:\u001cw\u000eZ3s+\t\t)\u0002E\u0003w\u0003/yt(C\u0002\u0002\u001au\u0011\u0001dQ8na>\u001c\u0018\u000e^3LKf\u001cF/\u0019;f\u000b:\u001cw\u000eZ3s\u0003I\u0019H/\u0019;f)f\u0004Xm]#oG>$WM\u001d\u0011\u0002\r\u0015D\u0018n\u001d;t)\t\t\t\u0003E\u0002.\u0003GI1!!\n/\u0005\u001d\u0011un\u001c7fC:\f\u0001bZ3u-\u0006dW/\u001a\u000b\u0004\u0005\u0006-\u0002BBA\u0017\u001f\u0001\u0007q'A\u0002lKf\f1bY8oi\u0006Lgn]&fsR!\u0011\u0011EA\u001a\u0011\u0019\ti\u0003\u0005a\u0001o\u0005YQ\u000f\u001d3bi\u00164\u0016\r\\;f)\u0019\tI$a\u0010\u0002BA\u0019Q&a\u000f\n\u0007\u0005ubF\u0001\u0003V]&$\bBBA\u0017#\u0001\u0007q\u0007\u0003\u0004\u0002DE\u0001\rAQ\u0001\u0006m\u0006dW/Z\u0001\tSR,'/\u0019;peR\u0011\u0011\u0011\n\t\u0007\u0003\u0017\n)&a\u0017\u000f\t\u00055\u0013\u0011\u000b\b\u0004-\u0006=\u0013\"A\u0018\n\u0007\u0005Mc&A\u0004qC\u000e\\\u0017mZ3\n\t\u0005]\u0013\u0011\f\u0002\t\u0013R,'/\u0019;pe*\u0019\u00111\u000b\u0018\u0011\u000b5\nif\u000e\"\n\u0007\u0005}cF\u0001\u0004UkBdWMM\u0001\u0005W\u0016L8\u000f\u0006\u0002\u0002fA)\u00111JA+o\u00051a/\u00197vKN$\"!a\u001b\u0011\u000b\u0005-\u0013Q\u000b\"\u0002\u0013I,Wn\u001c<f\u0017\u0016LH\u0003BA\u001d\u0003cBa!!\f\u0016\u0001\u00049\u0014!B2mK\u0006\u0014HCAA\u001d\u00031i\u0015\r]*uCR,\u0017*\u001c9m!\t1\bd\u0005\u0003\u0019Y\u0005u\u0004\u0003BA@\u0003\u0013k!!!!\u000b\t\u0005\r\u0015QQ\u0001\u0003S>T!!a\"\u0002\t)\fg/Y\u0005\u0005\u0003\u0017\u000b\tI\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0006\u0002\u0002z\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIY*b!a%\u0002*\u0006-VCAAKU\rQ\u0017qS\u0016\u0003\u00033\u0003B!a'\u0002&6\u0011\u0011Q\u0014\u0006\u0005\u0003?\u000b\t+A\u0005v]\u000eDWmY6fI*\u0019\u00111\u0015\u0018\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002(\u0006u%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0012)!H\u0007b\u0001w\u0011)AI\u0007b\u0001w\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u0011\u0011\u0017\t\u0005\u0003g\u000bI,\u0004\u0002\u00026*!\u0011qWAC\u0003\u0011a\u0017M\\4\n\t\u0005m\u0016Q\u0017\u0002\u0007\u001f\nTWm\u0019;")
public class MapStateImpl<K, V>
implements MapState<K, V>,
Logging {
    private final StateStore store;
    private final String stateName;
    private final Map<String, SQLMetric> metrics;
    private final StructType schemaForCompositeKeyRow;
    private final StructType schemaForValueRow;
    private final CompositeKeyStateEncoder<Object, Object> stateTypesEncoder;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static <K, V> Map<String, SQLMetric> $lessinit$greater$default$6() {
        return MapStateImpl$.MODULE$.$lessinit$greater$default$6();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(java.util.Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private StructType schemaForCompositeKeyRow() {
        return this.schemaForCompositeKeyRow;
    }

    private StructType schemaForValueRow() {
        return this.schemaForValueRow;
    }

    private CompositeKeyStateEncoder<Object, Object> stateTypesEncoder() {
        return this.stateTypesEncoder;
    }

    public boolean exists() {
        StateStoreIterator<UnsafeRowPair> iter = this.store.prefixScan(this.stateTypesEncoder().encodeGroupingKey(), this.stateName);
        boolean result = iter.nonEmpty();
        iter.close();
        return result;
    }

    public V getValue(K key) {
        StateStoreErrors$.MODULE$.requireNonNullStateValue(key, this.stateName);
        UnsafeRow encodedCompositeKey = this.stateTypesEncoder().encodeCompositeKey(key);
        UnsafeRow unsafeRowValue = this.store.get(encodedCompositeKey, this.stateName);
        if (unsafeRowValue == null) {
            return null;
        }
        return this.stateTypesEncoder().decodeValue(unsafeRowValue);
    }

    public boolean containsKey(K key) {
        StateStoreErrors$.MODULE$.requireNonNullStateValue(key, this.stateName);
        return this.getValue(key) != null;
    }

    public void updateValue(K key, V value) {
        StateStoreErrors$.MODULE$.requireNonNullStateValue(key, this.stateName);
        StateStoreErrors$.MODULE$.requireNonNullStateValue(value, this.stateName);
        UnsafeRow encodedValue = this.stateTypesEncoder().encodeValue(value);
        UnsafeRow encodedCompositeKey = this.stateTypesEncoder().encodeCompositeKey(key);
        this.store.put(encodedCompositeKey, encodedValue, this.stateName);
        TWSMetricsUtils$.MODULE$.incrementMetric(this.metrics, "numUpdatedStateRows", TWSMetricsUtils$.MODULE$.incrementMetric$default$3());
    }

    public Iterator<Tuple2<K, V>> iterator() {
        UnsafeRow encodedGroupingKey = this.stateTypesEncoder().encodeGroupingKey();
        return this.store.prefixScan(encodedGroupingKey, this.stateName).map((Function1 & Serializable)x0$1 -> {
            UnsafeRowPair unsafeRowPair = x0$1;
            if (unsafeRowPair != null) {
                UnsafeRowPair unsafeRowPair2 = unsafeRowPair;
                return new Tuple2(this.stateTypesEncoder().decodeCompositeKey(unsafeRowPair2.key()), this.stateTypesEncoder().decodeValue(unsafeRowPair2.value()));
            }
            throw new MatchError((Object)unsafeRowPair);
        });
    }

    public Iterator<K> keys() {
        return this.iterator().map((Function1 & Serializable)x$1 -> x$1._1());
    }

    public Iterator<V> values() {
        return this.iterator().map((Function1 & Serializable)x$2 -> x$2._2());
    }

    public void removeKey(K key) {
        StateStoreErrors$.MODULE$.requireNonNullStateValue(key, this.stateName);
        UnsafeRow compositeKey = this.stateTypesEncoder().encodeCompositeKey(key);
        this.store.remove(compositeKey, this.stateName);
        TWSMetricsUtils$.MODULE$.incrementMetric(this.metrics, "numRemovedStateRows", TWSMetricsUtils$.MODULE$.incrementMetric$default$3());
    }

    public void clear() {
        this.keys().foreach((Function1 & Serializable)itr -> {
            this.removeKey(itr);
            return BoxedUnit.UNIT;
        });
    }

    public MapStateImpl(StateStore store, String stateName, ExpressionEncoder<Object> keyExprEnc, ExpressionEncoder<Object> userKeyEnc, ExpressionEncoder<Object> valEncoder, Map<String, SQLMetric> metrics) {
        this.store = store;
        this.stateName = stateName;
        this.metrics = metrics;
        Logging.$init$((Logging)this);
        this.schemaForCompositeKeyRow = TransformWithStateKeyValueRowSchemaUtils$.MODULE$.getCompositeKeySchema(keyExprEnc.schema(), userKeyEnc.schema());
        this.schemaForValueRow = valEncoder.schema();
        this.stateTypesEncoder = new CompositeKeyStateEncoder<Object, Object>(keyExprEnc, (Encoder<Object>)userKeyEnc, (Encoder<Object>)valEncoder, stateName, CompositeKeyStateEncoder$.MODULE$.$lessinit$greater$default$5());
        store.createColFamilyIfAbsent(stateName, this.schemaForCompositeKeyRow(), this.schemaForValueRow(), new PrefixKeyScanStateEncoderSpec(this.schemaForCompositeKeyRow(), 1), store.createColFamilyIfAbsent$default$5(), store.createColFamilyIfAbsent$default$6());
    }
}

