/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.File;
import java.io.Serializable;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark.sql.execution.streaming.state.RocksDBFileManager;
import org.apache.spark.sql.execution.streaming.state.RocksDBImmutableFile;
import org.apache.spark.sql.execution.streaming.state.RocksDBImmutableFile$;
import org.apache.spark.sql.execution.streaming.state.RocksDBSnapshotFile;
import org.apache.spark.sql.execution.streaming.state.RocksDBVersionSnapshotInfo;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Mc\u0001B\b\u0011\u0001}AQA\n\u0001\u0005\u0002\u001dBqA\u000b\u0001C\u0002\u0013%1\u0006\u0003\u0004I\u0001\u0001\u0006I\u0001\f\u0005\b\u0013\u0002\u0011\r\u0011\"\u0001K\u0011\u00191\u0006\u0001)A\u0005\u0017\")q\u000b\u0001C\u00011\")A\f\u0001C!;\")a\f\u0001C\u0001?\")A\u000e\u0001C\u0005[\")\u0011\u0010\u0001C\u0005u\"9\u00111\u0002\u0001\u0005\u0002\u00055\u0001bBA\r\u0001\u0011\u0005\u00111\u0004\u0005\b\u0003?\u0001A\u0011BA\u0011\u0011\u001d\tI\u0004\u0001C\u0001\u0003w\u0011!CU8dWN$%IR5mK6\u000b\u0007\u000f]5oO*\u0011\u0011CE\u0001\u0006gR\fG/\u001a\u0006\u0003'Q\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005U1\u0012!C3yK\u000e,H/[8o\u0015\t9\u0002$A\u0002tc2T!!\u0007\u000e\u0002\u000bM\u0004\u0018M]6\u000b\u0005ma\u0012AB1qC\u000eDWMC\u0001\u001e\u0003\ry'oZ\u0002\u0001'\t\u0001\u0001\u0005\u0005\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#E\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003!\u0002\"!\u000b\u0001\u000e\u0003A\t\u0011\u0003\\8dC24\u0015\u000e\\3NCB\u0004\u0018N\\4t+\u0005a\u0003\u0003B\u00173i}j\u0011A\f\u0006\u0003_A\nq!\\;uC\ndWM\u0003\u00022E\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005Mr#aA'baB\u0011Q\u0007\u0010\b\u0003mi\u0002\"a\u000e\u0012\u000e\u0003aR!!\u000f\u0010\u0002\rq\u0012xn\u001c;?\u0013\tY$%\u0001\u0004Qe\u0016$WMZ\u0005\u0003{y\u0012aa\u0015;sS:<'BA\u001e#!\u0011\t\u0003IQ#\n\u0005\u0005\u0013#A\u0002+va2,'\u0007\u0005\u0002\"\u0007&\u0011AI\t\u0002\u0005\u0019>tw\r\u0005\u0002*\r&\u0011q\t\u0005\u0002\u0015%>\u001c7n\u001d#C\u00136lW\u000f^1cY\u00164\u0015\u000e\\3\u0002%1|7-\u00197GS2,W*\u00199qS:<7\u000fI\u0001\u0017g:\f\u0007o\u001d5piN\u0004VM\u001c3j]\u001e,\u0006\u000f\\8bIV\t1\nE\u0002M#Nk\u0011!\u0014\u0006\u0003\u001d>\u000bA!\u001e;jY*\t\u0001+\u0001\u0003kCZ\f\u0017B\u0001*N\u0005\r\u0019V\r\u001e\t\u0003SQK!!\u0016\t\u00035I{7m[:E\u0005Z+'o]5p]Ns\u0017\r]:i_RLeNZ8\u0002/Mt\u0017\r]:i_R\u001c\b+\u001a8eS:<W\u000b\u001d7pC\u0012\u0004\u0013!B2mK\u0006\u0014H#A-\u0011\u0005\u0005R\u0016BA.#\u0005\u0011)f.\u001b;\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012\u0001N\u0001\u0012O\u0016$HIZ:GS2,gi\u001c:M_\u0006$G\u0003\u00021dQ*\u00042!I1F\u0013\t\u0011'E\u0001\u0004PaRLwN\u001c\u0005\u0006I\"\u0001\r!Z\u0001\fM&dW-T1oC\u001e,'\u000f\u0005\u0002*M&\u0011q\r\u0005\u0002\u0013%>\u001c7n\u001d#C\r&dW-T1oC\u001e,'\u000fC\u0003j\u0011\u0001\u0007A'A\u0007m_\u000e\fGNR5mK:\u000bW.\u001a\u0005\u0006W\"\u0001\rAQ\u0001\u000em\u0016\u00148/[8o)>du.\u00193\u0002#\u001d,G\u000f\u00124t\r&dWMR8s'\u00064X\r\u0006\u0003a]><\b\"\u00023\n\u0001\u0004)\u0007\"\u00029\n\u0001\u0004\t\u0018!\u00037pG\u0006dg)\u001b7f!\t\u0011X/D\u0001t\u0015\t!x*\u0001\u0002j_&\u0011ao\u001d\u0002\u0005\r&dW\rC\u0003y\u0013\u0001\u0007!)A\u0007wKJ\u001c\u0018n\u001c8U_N\u000bg/Z\u0001#O\u0016$HIZ:GS2,w+\u001b;i\u0013:\u001cw.\u001c9bi&\u0014\u0017\u000e\\5us\u000eCWmY6\u0015\t\u0001\\H0 \u0005\u0006I*\u0001\r!\u001a\u0005\u0006S*\u0001\r\u0001\u000e\u0005\u0006}*\u0001\ra`\u0001\u000fSNLenY8na\u0006$\u0018N\u00197f!\u001d\t\u0013\u0011\u0001\"F\u0003\u000bI1!a\u0001#\u0005%1UO\\2uS>t'\u0007E\u0002\"\u0003\u000fI1!!\u0003#\u0005\u001d\u0011un\u001c7fC:\fA\"\\1q)>$em\u001d$jY\u0016$r!WA\b\u0003#\t)\u0002C\u0003j\u0017\u0001\u0007A\u0007\u0003\u0004\u0002\u0014-\u0001\r!R\u0001\bI\u001a\u001ch)\u001b7f\u0011\u0019\t9b\u0003a\u0001\u0005\u00069a/\u001a:tS>t\u0017A\u0002:f[>4X\rF\u0002Z\u0003;AQ!\u001b\u0007A\u0002Q\n!c]=oG^KG\u000f\u001b'pG\u0006d7\u000b^1uKR\u0019\u0011,a\t\t\u000f\u0005\u0015R\u00021\u0001\u0002(\u0005QAn\\2bY\u001aKG.Z:\u0011\u000b\u0005%\u00121G9\u000f\t\u0005-\u0012q\u0006\b\u0004o\u00055\u0012\"A\u0012\n\u0007\u0005E\"%A\u0004qC\u000e\\\u0017mZ3\n\t\u0005U\u0012q\u0007\u0002\u0004'\u0016\f(bAA\u0019E\u0005I2M]3bi\u0016\u001cf.\u00199tQ>$h)\u001b7f\u001b\u0006\u0004\b/\u001b8h)!\ti$a\u0013\u0002N\u0005E\u0003#B\u0011Ai\u0005}\u0002cBA!\u0003\u0007\"\u0014QI\u0007\u0002a%\u00111\u0007\r\t\u0004S\u0005\u001d\u0013bAA%!\t\u0019\"k\\2lg\u0012\u00135K\\1qg\"|GOR5mK\")AM\u0004a\u0001K\"1\u0011q\n\bA\u0002E\fQb\u00195fG.\u0004x.\u001b8u\t&\u0014\bBBA\f\u001d\u0001\u0007!\t")
public class RocksDBFileMapping {
    private final scala.collection.mutable.Map<String, Tuple2<Object, RocksDBImmutableFile>> localFileMappings = (scala.collection.mutable.Map)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final Set<RocksDBVersionSnapshotInfo> snapshotsPendingUpload = ConcurrentHashMap.newKeySet();

    private scala.collection.mutable.Map<String, Tuple2<Object, RocksDBImmutableFile>> localFileMappings() {
        return this.localFileMappings;
    }

    public Set<RocksDBVersionSnapshotInfo> snapshotsPendingUpload() {
        return this.snapshotsPendingUpload;
    }

    public void clear() {
        this.localFileMappings().clear();
        this.snapshotsPendingUpload().clear();
    }

    public String toString() {
        return this.localFileMappings().toString();
    }

    public Option<RocksDBImmutableFile> getDfsFileForLoad(RocksDBFileManager fileManager, String localFileName, long versionToLoad) {
        return this.getDfsFileWithIncompatibilityCheck(fileManager, localFileName, (Function2<Object, RocksDBImmutableFile, Object>)(Function2 & Serializable)(fileVersion, x$33) -> BoxesRunTime.boxToBoolean((boolean)RocksDBFileMapping.$anonfun$getDfsFileForLoad$1(versionToLoad, BoxesRunTime.unboxToLong((Object)fileVersion), x$33)));
    }

    private Option<RocksDBImmutableFile> getDfsFileForSave(RocksDBFileManager fileManager, File localFile, long versionToSave) {
        return this.getDfsFileWithIncompatibilityCheck(fileManager, localFile.getName(), (Function2<Object, RocksDBImmutableFile, Object>)(Function2 & Serializable)(dfsFileVersion, dfsFile) -> BoxesRunTime.boxToBoolean((boolean)RocksDBFileMapping.$anonfun$getDfsFileForSave$1(versionToSave, localFile, BoxesRunTime.unboxToLong((Object)dfsFileVersion), dfsFile)));
    }

    private Option<RocksDBImmutableFile> getDfsFileWithIncompatibilityCheck(RocksDBFileManager fileManager, String localFileName, Function2<Object, RocksDBImmutableFile, Object> isIncompatible) {
        return (Option)this.localFileMappings().get((Object)localFileName).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                long dfsFileMappedVersion = tuple2._1$mcJ$sp();
                RocksDBImmutableFile dfsFile = (RocksDBImmutableFile)tuple2._2();
                String dfsFileSuffix = fileManager.dfsFileSuffix(dfsFile);
                RocksDBVersionSnapshotInfo versionSnapshotInfo = new RocksDBVersionSnapshotInfo(dfsFileMappedVersion, dfsFileSuffix);
                if (BoxesRunTime.unboxToBoolean((Object)isIncompatible.apply((Object)BoxesRunTime.boxToLong((long)dfsFileMappedVersion), (Object)dfsFile)) || this.snapshotsPendingUpload().contains(versionSnapshotInfo)) {
                    this.remove(localFileName);
                    return None$.MODULE$;
                }
                return new Some((Object)dfsFile);
            }
            throw new MatchError((Object)tuple2);
        }).getOrElse((Function0 & Serializable)() -> None$.MODULE$);
    }

    public void mapToDfsFile(String localFileName, RocksDBImmutableFile dfsFile, long version) {
        this.localFileMappings().put((Object)localFileName, (Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)version), (Object)dfsFile));
    }

    public void remove(String localFileName) {
        this.localFileMappings().remove((Object)localFileName);
    }

    private void syncWithLocalState(Seq<File> localFiles) {
        scala.collection.immutable.Set localFileNames = ((IterableOnceOps)localFiles.map((Function1 & Serializable)x$34 -> x$34.getName())).toSet();
        Iterable deletedFiles = (Iterable)this.localFileMappings().keys().filterNot((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)localFileNames.contains((Object)elem)));
        deletedFiles.foreach((Function1 & Serializable)key -> this.localFileMappings().remove(key));
    }

    public Tuple2<String, Map<String, RocksDBSnapshotFile>> createSnapshotFileMapping(RocksDBFileManager fileManager, File checkpointDir, long version) {
        Tuple2<Seq<File>, Seq<File>> tuple2 = fileManager.listRocksDBFiles(checkpointDir);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq localImmutableFiles = (Seq)tuple2._1();
        Seq localImmutableFiles2 = localImmutableFiles;
        String dfsFilesSuffix = UUID.randomUUID().toString();
        scala.collection.immutable.Map snapshotFileMapping = ((IterableOnceOps)localImmutableFiles2.map((Function1 & Serializable)f -> {
            String localFileName = f.getName();
            Option<RocksDBImmutableFile> existingDfsFile = this.getDfsFileForSave(fileManager, (File)f, version);
            RocksDBImmutableFile dfsFile = (RocksDBImmutableFile)existingDfsFile.getOrElse((Function0 & Serializable)() -> {
                String newDfsFileName = fileManager.newDFSFileName(localFileName, dfsFilesSuffix);
                RocksDBImmutableFile newDfsFile = RocksDBImmutableFile$.MODULE$.apply(localFileName, newDfsFileName, f.length());
                this.mapToDfsFile(localFileName, newDfsFile, version);
                return newDfsFile;
            });
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)localFileName), (Object)new RocksDBSnapshotFile(dfsFile, existingDfsFile.isDefined()));
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.syncWithLocalState((Seq<File>)localImmutableFiles2);
        RocksDBVersionSnapshotInfo rocksDBSnapshotInfo = new RocksDBVersionSnapshotInfo(version, dfsFilesSuffix);
        this.snapshotsPendingUpload().add(rocksDBSnapshotInfo);
        return new Tuple2((Object)dfsFilesSuffix, (Object)snapshotFileMapping);
    }

    public static final /* synthetic */ boolean $anonfun$getDfsFileForLoad$1(long versionToLoad$1, long fileVersion, RocksDBImmutableFile x$33) {
        return fileVersion >= versionToLoad$1;
    }

    public static final /* synthetic */ boolean $anonfun$getDfsFileForSave$1(long versionToSave$1, File localFile$1, long dfsFileVersion, RocksDBImmutableFile dfsFile) {
        return dfsFileVersion >= versionToSave$1 || dfsFile.sizeBytes() != localFile$1.length();
    }
}

