/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.io.DataInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException$;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.config.package$;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.buffer.NioManagedBuffer;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.shuffle.IndexShuffleBlockResolver$;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.BlockManagerId$;
import org.apache.spark.storage.BlockManagerMaster;
import org.apache.spark.storage.FallbackStorage;
import org.apache.spark.storage.NoopRpcEndpointRef;
import org.apache.spark.storage.ShuffleBlockBatchId;
import org.apache.spark.storage.ShuffleBlockId;
import org.apache.spark.storage.ShuffleDataBlockId;
import org.apache.spark.storage.ShuffleIndexBlockId;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple4;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class FallbackStorage$
implements Logging {
    public static final FallbackStorage$ MODULE$ = new FallbackStorage$();
    private static final BlockManagerId FALLBACK_BLOCK_MANAGER_ID;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        FALLBACK_BLOCK_MANAGER_ID = BlockManagerId$.MODULE$.apply("fallback", "remote", 7337, BlockManagerId$.MODULE$.apply$default$4());
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public BlockManagerId FALLBACK_BLOCK_MANAGER_ID() {
        return FALLBACK_BLOCK_MANAGER_ID;
    }

    public Option<FallbackStorage> getFallbackStorage(SparkConf conf) {
        if (((Option)conf.get(package$.MODULE$.STORAGE_DECOMMISSION_FALLBACK_STORAGE_PATH())).isDefined()) {
            return new Some((Object)new FallbackStorage(conf));
        }
        return None$.MODULE$;
    }

    public void registerBlockManagerIfNeeded(BlockManagerMaster master, SparkConf conf) {
        if (((Option)conf.get(package$.MODULE$.STORAGE_DECOMMISSION_FALLBACK_STORAGE_PATH())).isDefined()) {
            master.registerBlockManager(this.FALLBACK_BLOCK_MANAGER_ID(), (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), 0L, 0L, new NoopRpcEndpointRef(conf), master.registerBlockManager$default$6());
            return;
        }
    }

    public void cleanUp(SparkConf conf, Configuration hadoopConf) {
        if (((Option)conf.get(package$.MODULE$.STORAGE_DECOMMISSION_FALLBACK_STORAGE_PATH())).isDefined() && BoxesRunTime.unboxToBoolean((Object)conf.get(package$.MODULE$.STORAGE_DECOMMISSION_FALLBACK_STORAGE_CLEANUP())) && conf.contains("spark.app.id")) {
            Path fallbackPath = new Path((String)((Option)conf.get(package$.MODULE$.STORAGE_DECOMMISSION_FALLBACK_STORAGE_PATH())).get(), conf.getAppId());
            URI fallbackUri = fallbackPath.toUri();
            FileSystem fallbackFileSystem = FileSystem.get((URI)fallbackUri, (Configuration)hadoopConf);
            if (fallbackFileSystem.exists(fallbackPath)) {
                if (fallbackFileSystem.delete(fallbackPath, true)) {
                    this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Succeed to clean up: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.URI$.MODULE$, (Object)fallbackUri)}))));
                    return;
                }
                this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to clean up: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.URI$.MODULE$, (Object)fallbackUri)}))));
                return;
            }
            return;
        }
    }

    public boolean org$apache$spark$storage$FallbackStorage$$reportBlockStatus(BlockManager blockManager, BlockId blockId, long dataLength) {
        Predef$.MODULE$.assert(blockManager.master() != null);
        return blockManager.master().updateBlockInfo(this.FALLBACK_BLOCK_MANAGER_ID(), blockId, StorageLevel$.MODULE$.DISK_ONLY(), 0L, dataLength);
    }

    public ManagedBuffer read(SparkConf conf, BlockId blockId) {
        Tuple4 tuple4;
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Read ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.BLOCK_ID$.MODULE$, (Object)blockId)}))));
        Path fallbackPath = new Path((String)((Option)conf.get(package$.MODULE$.STORAGE_DECOMMISSION_FALLBACK_STORAGE_PATH())).get());
        Configuration hadoopConf = SparkHadoopUtil$.MODULE$.get().newConfiguration(conf);
        FileSystem fallbackFileSystem = FileSystem.get((URI)fallbackPath.toUri(), (Configuration)hadoopConf);
        String appId = conf.getAppId();
        BlockId blockId2 = blockId;
        if (blockId2 instanceof ShuffleBlockId) {
            ShuffleBlockId shuffleBlockId = (ShuffleBlockId)blockId2;
            tuple4 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)shuffleBlockId.shuffleId()), (Object)BoxesRunTime.boxToLong((long)shuffleBlockId.mapId()), (Object)BoxesRunTime.boxToInteger((int)shuffleBlockId.reduceId()), (Object)BoxesRunTime.boxToInteger((int)(shuffleBlockId.reduceId() + 1)));
        } else if (blockId2 instanceof ShuffleBlockBatchId) {
            ShuffleBlockBatchId shuffleBlockBatchId = (ShuffleBlockBatchId)blockId2;
            tuple4 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)shuffleBlockBatchId.shuffleId()), (Object)BoxesRunTime.boxToLong((long)shuffleBlockBatchId.mapId()), (Object)BoxesRunTime.boxToInteger((int)shuffleBlockBatchId.startReduceId()), (Object)BoxesRunTime.boxToInteger((int)shuffleBlockBatchId.endReduceId()));
        } else {
            throw SparkException$.MODULE$.internalError("unexpected shuffle block id format: " + blockId, "STORAGE");
        }
        Tuple4 tuple42 = tuple4;
        if (tuple42 == null) {
            throw new MatchError((Object)tuple42);
        }
        int shuffleId = BoxesRunTime.unboxToInt((Object)tuple42._1());
        long mapId = BoxesRunTime.unboxToLong((Object)tuple42._2());
        int startReduceId = BoxesRunTime.unboxToInt((Object)tuple42._3());
        int endReduceId = BoxesRunTime.unboxToInt((Object)tuple42._4());
        Tuple4 tuple43 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)shuffleId), (Object)BoxesRunTime.boxToLong((long)mapId), (Object)BoxesRunTime.boxToInteger((int)startReduceId), (Object)BoxesRunTime.boxToInteger((int)endReduceId));
        int shuffleId2 = BoxesRunTime.unboxToInt((Object)tuple43._1());
        long mapId2 = BoxesRunTime.unboxToLong((Object)tuple43._2());
        int startReduceId2 = BoxesRunTime.unboxToInt((Object)tuple43._3());
        int endReduceId2 = BoxesRunTime.unboxToInt((Object)tuple43._4());
        String name = new ShuffleIndexBlockId(shuffleId2, mapId2, IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID()).name();
        int hash = JavaUtils.nonNegativeHash((Object)name);
        Path indexFile = new Path(fallbackPath, appId + "/" + shuffleId2 + "/" + hash + "/" + name);
        long start = (long)startReduceId2 * 8L;
        long end = (long)endReduceId2 * 8L;
        return (ManagedBuffer)Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> fallbackFileSystem.open(indexFile), (Function1 & Serializable)inputStream -> (NioManagedBuffer)Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> new DataInputStream((InputStream)inputStream), (Function1 & Serializable)index -> {
            index.skip(start);
            long offset = index.readLong();
            index.skip(end - (start + 8L));
            long nextOffset = index.readLong();
            String name = new ShuffleDataBlockId(shuffleId2, mapId2, IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID()).name();
            int hash = JavaUtils.nonNegativeHash((Object)name);
            Path dataFile = new Path(fallbackPath, appId + "/" + shuffleId2 + "/" + hash + "/" + name);
            long size = nextOffset - offset;
            MODULE$.logDebug((Function0<String>)(Function0 & Serializable)() -> "To byte array " + size);
            byte[] array = new byte[(int)size];
            long startTimeNs = System.nanoTime();
            Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> fallbackFileSystem.open(dataFile), (Function1 & Serializable)f -> {
                FallbackStorage$.$anonfun$read$8(offset, array, startTimeNs, f);
                return BoxedUnit.UNIT;
            });
            return new NioManagedBuffer(ByteBuffer.wrap(array));
        }));
    }

    public static final /* synthetic */ void $anonfun$read$8(long offset$1, byte[] array$1, long startTimeNs$1, FSDataInputStream f) {
        f.seek(offset$1);
        f.readFully(array$1);
        MODULE$.logDebug((Function0<String>)(Function0 & Serializable)() -> "Took " + (System.nanoTime() - startTimeNs$1) / 1000000L + "ms");
    }

    private FallbackStorage$() {
    }
}

