/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis.resolver;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.resolver.TimezoneAwareExpressionResolver;
import org.apache.spark.sql.catalyst.analysis.resolver.TreeNodeResolver;
import org.apache.spark.sql.catalyst.analysis.resolver.TypeCoercionResolver$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005!4A\u0001E\t\u0001A!A\u0011\u0007\u0001B\u0001B\u0003%!\u0007\u0003\u00056\u0001\t\u0005\t\u0015!\u00037\u0011\u0015)\u0005\u0001\"\u0001G\u0011\u001dQ\u0005A1A\u0005\n-Ca\u0001\u0014\u0001!\u0002\u00131\u0004\"B'\u0001\t\u0003r\u0005\"B)\u0001\t\u0013\u0011v!\u0002+\u0012\u0011\u0003)f!\u0002\t\u0012\u0011\u00031\u0006\"B#\n\t\u00039\u0006b\u0002-\n\u0005\u0004%Ia\u0013\u0005\u00073&\u0001\u000b\u0011\u0002\u001c\t\u000fiK!\u0019!C\u0005\u0017\"11,\u0003Q\u0001\nYBq\u0001X\u0005\u0012\u0002\u0013\u0005QL\u0001\u000bUsB,7i\\3sG&|gNU3t_24XM\u001d\u0006\u0003%M\t\u0001B]3t_24XM\u001d\u0006\u0003)U\t\u0001\"\u00198bYf\u001c\u0018n\u001d\u0006\u0003-]\t\u0001bY1uC2L8\u000f\u001e\u0006\u00031e\t1a]9m\u0015\tQ2$A\u0003ta\u0006\u00148N\u0003\u0002\u001d;\u00051\u0011\r]1dQ\u0016T\u0011AH\u0001\u0004_J<7\u0001A\n\u0004\u0001\u0005:\u0003C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#AB!osJ+g\r\u0005\u0003)S-ZS\"A\t\n\u0005)\n\"\u0001\u0005+sK\u0016tu\u000eZ3SKN|GN^3s!\tas&D\u0001.\u0015\tqS#A\u0006fqB\u0014Xm]:j_:\u001c\u0018B\u0001\u0019.\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001 i&lWM_8oK\u0006;\u0018M]3FqB\u0014Xm]:j_:\u0014Vm]8mm\u0016\u0014\bC\u0001\u00154\u0013\t!\u0014CA\u0010US6,'p\u001c8f\u0003^\f'/Z#yaJ,7o]5p]J+7o\u001c7wKJ\f1\u0004^=qK\u000e{WM]2j_:$&/\u00198tM>\u0014X.\u0019;j_:\u001c\bcA\u001c@\u0005:\u0011\u0001(\u0010\b\u0003sqj\u0011A\u000f\u0006\u0003w}\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0013\n\u0005y\u001a\u0013a\u00029bG.\fw-Z\u0005\u0003\u0001\u0006\u00131aU3r\u0015\tq4\u0005\u0005\u0003#\u0007.Z\u0013B\u0001#$\u0005%1UO\\2uS>t\u0017'\u0001\u0004=S:LGO\u0010\u000b\u0004\u000f\"K\u0005C\u0001\u0015\u0001\u0011\u0015\t4\u00011\u00013\u0011\u001d)4\u0001%AA\u0002Y\nA\u0005^=qK\u000e{WM]2j_:$&/\u00198tM>\u0014X.\u0019;j_:\u001cxJ\u001d#fM\u0006,H\u000e^\u000b\u0002m\u0005)C/\u001f9f\u0007>,'oY5p]R\u0013\u0018M\\:g_Jl\u0017\r^5p]N|%\u000fR3gCVdG\u000fI\u0001\be\u0016\u001cx\u000e\u001c<f)\tYs\nC\u0003Q\r\u0001\u00071&\u0001\u0006fqB\u0014Xm]:j_:\f\u0011#\u00199qYf$\u0016\u0010]3D_\u0016\u00148-[8o)\tY3\u000bC\u0003Q\u000f\u0001\u00071&\u0001\u000bUsB,7i\\3sG&|gNU3t_24XM\u001d\t\u0003Q%\u0019\"!C\u0011\u0015\u0003U\u000bQ\u0004V-Q\u000b~\u001bu*\u0012*D\u0013>su\f\u0016*B\u001dN3uJU'B)&{ejU\u0001\u001f)f\u0003ViX\"P\u000bJ\u001b\u0015j\u0014(`)J\u000bej\u0015$P%6\u000bE+S(O'\u0002\n!%\u0011(T\u0013~#\u0016\fU#`\u0007>+%kQ%P\u001d~#&+\u0011(T\r>\u0013V*\u0011+J\u001f:\u001b\u0016aI!O'&{F+\u0017)F?\u000e{UIU\"J\u001f:{FKU!O'\u001a{%+T!U\u0013>s5\u000bI\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0003yS#AN0,\u0003\u0001\u0004\"!\u00194\u000e\u0003\tT!a\u00193\u0002\u0013Ut7\r[3dW\u0016$'BA3$\u0003)\tgN\\8uCRLwN\\\u0005\u0003O\n\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class TypeCoercionResolver
implements TreeNodeResolver<Expression, Expression> {
    private final TimezoneAwareExpressionResolver timezoneAwareExpressionResolver;
    private final Seq<Function1<Expression, Expression>> typeCoercionTransformationsOrDefault;

    public static Seq<Function1<Expression, Expression>> $lessinit$greater$default$2() {
        return TypeCoercionResolver$.MODULE$.$lessinit$greater$default$2();
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    @Override
    public SQLConf conf() {
        return SQLConfHelper.conf$(this);
    }

    @Override
    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$(this, pairs, f);
    }

    private Seq<Function1<Expression, Expression>> typeCoercionTransformationsOrDefault() {
        return this.typeCoercionTransformationsOrDefault;
    }

    @Override
    public Expression resolve(Expression expression) {
        Expression withTypeCoercedOnce = this.applyTypeCoercion(expression);
        return this.applyTypeCoercion(withTypeCoercedOnce);
    }

    private Expression applyTypeCoercion(Expression expression) {
        Seq oldChildren = expression.children();
        Expression withTypeCoercion = (Expression)this.typeCoercionTransformationsOrDefault().foldLeft((Object)expression, (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Expression expr = (Expression)tuple2._1();
                Function1 rule = (Function1)tuple2._2();
                return (Expression)rule.apply((Object)expr);
            }
            throw new MatchError((Object)tuple2);
        });
        Seq newChildren = (Seq)((IterableOps)withTypeCoercion.children().zip(oldChildren)).map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                Cast cast;
                Expression newChild = (Expression)tuple2._1();
                Expression oldChild = (Expression)tuple2._2();
                if (newChild instanceof Cast && (cast = (Cast)newChild) != oldChild) {
                    return $this.timezoneAwareExpressionResolver.withResolvedTimezone(cast, this.conf().sessionLocalTimeZone());
                }
            }
            if (tuple2 != null) {
                Expression newChild = (Expression)tuple2._1();
                return newChild;
            }
            throw new MatchError((Object)tuple2);
        });
        return (Expression)withTypeCoercion.withNewChildren(newChildren);
    }

    public TypeCoercionResolver(TimezoneAwareExpressionResolver timezoneAwareExpressionResolver, Seq<Function1<Expression, Expression>> typeCoercionTransformations) {
        this.timezoneAwareExpressionResolver = timezoneAwareExpressionResolver;
        SQLConfHelper.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        this.typeCoercionTransformationsOrDefault = typeCoercionTransformations.nonEmpty() ? typeCoercionTransformations : (this.conf().ansiEnabled() ? TypeCoercionResolver$.MODULE$.org$apache$spark$sql$catalyst$analysis$resolver$TypeCoercionResolver$$ANSI_TYPE_COERCION_TRANSFORMATIONS() : TypeCoercionResolver$.MODULE$.org$apache$spark$sql$catalyst$analysis$resolver$TypeCoercionResolver$$TYPE_COERCION_TRANSFORMATIONS());
    }
}

