/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.analysis.package$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExtractValue$;
import org.apache.spark.sql.catalyst.expressions.HigherOrderFunction;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction$;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.NamedLambdaVariable;
import org.apache.spark.sql.catalyst.expressions.NamedLambdaVariable$;
import org.apache.spark.sql.catalyst.expressions.UnresolvedNamedLambdaVariable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.trees.TreePatternBits;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;

public final class ResolveLambdaVariables$
extends Rule<LogicalPlan> {
    public static final ResolveLambdaVariables$ MODULE$ = new ResolveLambdaVariables$();

    private Function1<String, String> canonicalizer() {
        if (!this.conf().caseSensitiveAnalysis()) {
            return (Function1 & Serializable)s -> s.toLowerCase();
        }
        return (Function1 & Serializable)s -> s;
    }

    @Override
    public LogicalPlan apply(LogicalPlan plan2) {
        return plan2.resolveOperatorsWithPruning((Function1<TreePatternBits, Object>)(Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.containsAnyPattern((Seq<Enumeration.Value>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{TreePattern$.MODULE$.HIGH_ORDER_FUNCTION(), TreePattern$.MODULE$.LAMBDA_FUNCTION(), TreePattern$.MODULE$.LAMBDA_VARIABLE()}))), this.ruleId(), (PartialFunction<LogicalPlan, LogicalPlan>)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    A1 A12 = A1;
                    return (B1)A12.mapExpressions((Function1<Expression, Expression>)(Function1 & Serializable)x$2 -> ResolveLambdaVariables$.MODULE$.org$apache$spark$sql$catalyst$analysis$ResolveLambdaVariables$$resolve((Expression)x$2, (Map<String, NamedExpression>)Predef$.MODULE$.Map().empty()));
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                return logicalPlan != null;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.catalyst.expressions.Expression )}, serializedLambda);
            }
        });
    }

    private LambdaFunction createLambda(Expression e, Seq<Tuple2<DataType, Object>> argInfo) {
        boolean bl = false;
        LambdaFunction lambdaFunction = null;
        Expression expression = e;
        if (expression instanceof LambdaFunction) {
            bl = true;
            lambdaFunction = (LambdaFunction)expression;
            if (lambdaFunction.bound()) {
                return lambdaFunction;
            }
        }
        if (bl) {
            Expression function = lambdaFunction.function();
            Seq<NamedExpression> names = lambdaFunction.arguments();
            if (names.size() != argInfo.size()) {
                throw package$.MODULE$.AnalysisErrorAt(e).failAnalysis("INVALID_LAMBDA_FUNCTION_CALL.NUM_ARGS_MISMATCH", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expectedNumArgs"), (Object)Integer.toString(names.size())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"actualNumArgs"), (Object)Integer.toString(argInfo.size()))}))));
            }
            if (((SeqOps)((SeqOps)names.map((Function1 & Serializable)a -> (String)MODULE$.canonicalizer().apply((Object)a.name()))).distinct()).size() < names.size()) {
                throw package$.MODULE$.AnalysisErrorAt(e).failAnalysis("INVALID_LAMBDA_FUNCTION_CALL.DUPLICATE_ARG_NAMES", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"args"), (Object)((IterableOnceOps)((IterableOps)names.map((Function1 & Serializable)a -> (String)MODULE$.canonicalizer().apply((Object)a.name()))).map((Function1 & Serializable)x$3 -> TypeUtils$.MODULE$.toSQLId((String)x$3))).mkString(", ")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"caseSensitiveConfig"), (Object)TypeUtils$.MODULE$.toSQLConf(SQLConf$.MODULE$.CASE_SENSITIVE().key()))}))));
            }
            Seq arguments = (Seq)((IterableOps)argInfo.zip(names)).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    NamedExpression ne = (NamedExpression)tuple2._2();
                    if (tuple22 != null) {
                        DataType dataType = (DataType)tuple22._1();
                        boolean nullable = tuple22._2$mcZ$sp();
                        return new NamedLambdaVariable(ne.name(), dataType, nullable, NamedLambdaVariable$.MODULE$.apply$default$4(), NamedLambdaVariable$.MODULE$.apply$default$5());
                    }
                }
                throw new MatchError((Object)tuple2);
            });
            return new LambdaFunction(function, (Seq<NamedExpression>)arguments, LambdaFunction$.MODULE$.apply$default$3());
        }
        Seq arguments = (Seq)((IterableOps)argInfo.zipWithIndex()).map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                int i = tuple2._2$mcI$sp();
                if (tuple22 != null) {
                    DataType dataType = (DataType)tuple22._1();
                    boolean nullable = tuple22._2$mcZ$sp();
                    return new NamedLambdaVariable("col" + i, dataType, nullable, NamedLambdaVariable$.MODULE$.apply$default$4(), NamedLambdaVariable$.MODULE$.apply$default$5());
                }
            }
            throw new MatchError((Object)tuple2);
        });
        return new LambdaFunction(e, (Seq<NamedExpression>)arguments, true);
    }

    public Expression org$apache$spark$sql$catalyst$analysis$ResolveLambdaVariables$$resolve(Expression e2, Map<String, NamedExpression> parentLambdaMap) {
        Option option;
        UnresolvedNamedLambdaVariable unresolvedNamedLambdaVariable;
        Seq<String> seq;
        HigherOrderFunction higherOrderFunction;
        boolean bl = false;
        LambdaFunction lambdaFunction = null;
        Expression expression = e2;
        if (e2.resolved()) {
            return e2;
        }
        if (expression instanceof HigherOrderFunction && (higherOrderFunction = (HigherOrderFunction)((Object)expression)).argumentsResolved() && higherOrderFunction.checkArgumentDataTypes().isSuccess()) {
            this.checkForSubqueryExpressions(e2);
            return (Expression)((TreeNode)((Object)higherOrderFunction.bind((Function2<Expression, Seq<Tuple2<DataType, Object>>, LambdaFunction>)(Function2 & Serializable)(e, argInfo) -> MODULE$.createLambda((Expression)e, (Seq<Tuple2<DataType, Object>>)argInfo)))).mapChildren((Function1 & Serializable)x$4 -> MODULE$.org$apache$spark$sql$catalyst$analysis$ResolveLambdaVariables$$resolve((Expression)x$4, parentLambdaMap));
        }
        if (expression instanceof LambdaFunction) {
            bl = true;
            lambdaFunction = (LambdaFunction)expression;
            if (!lambdaFunction.bound()) {
                this.checkForSubqueryExpressions(e2);
                return lambdaFunction;
            }
        }
        if (bl && !lambdaFunction.hidden()) {
            Map lambdaMap = ((IterableOnceOps)lambdaFunction.arguments().map((Function1 & Serializable)v -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.canonicalizer().apply((Object)v.name())), v))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            return (Expression)lambdaFunction.mapChildren((Function1 & Serializable)x$5 -> MODULE$.org$apache$spark$sql$catalyst$analysis$ResolveLambdaVariables$$resolve((Expression)x$5, (Map<String, NamedExpression>)((Map)parentLambdaMap.$plus$plus((IterableOnce)lambdaMap))));
        }
        if (expression instanceof UnresolvedNamedLambdaVariable && (seq = (unresolvedNamedLambdaVariable = (UnresolvedNamedLambdaVariable)expression).nameParts()) != null && !(option = scala.package$.MODULE$.$plus$colon().unapply(seq)).isEmpty()) {
            String name = (String)((Tuple2)option.get())._1();
            Seq nestedFields = (Seq)((Tuple2)option.get())._2();
            Option option2 = parentLambdaMap.get(this.canonicalizer().apply((Object)name));
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                NamedExpression lambda = (NamedExpression)some.value();
                return (Expression)nestedFields.foldLeft((Object)((Expression)((Object)lambda)), (Function2 & Serializable)(expr, fieldName) -> ExtractValue$.MODULE$.apply((Expression)expr, Literal$.MODULE$.apply(fieldName), MODULE$.conf().resolver()));
            }
            if (None$.MODULE$.equals(option2)) {
                return new UnresolvedAttribute(unresolvedNamedLambdaVariable.nameParts());
            }
            throw new MatchError((Object)option2);
        }
        return (Expression)e2.mapChildren((Function1 & Serializable)x$6 -> MODULE$.org$apache$spark$sql$catalyst$analysis$ResolveLambdaVariables$$resolve((Expression)x$6, parentLambdaMap));
    }

    private void checkForSubqueryExpressions(Expression expression) {
        if (expression.containsPattern(TreePattern$.MODULE$.PLAN_EXPRESSION()) && !BoxesRunTime.unboxToBoolean((Object)this.conf().getConf(SQLConf$.MODULE$.ALLOW_SUBQUERY_EXPRESSIONS_IN_LAMBDAS_AND_HIGHER_ORDER_FUNCTIONS()))) {
            throw QueryCompilationErrors$.MODULE$.subqueryExpressionInLambdaOrHigherOrderFunctionNotAllowedError();
        }
    }

    private ResolveLambdaVariables$() {
    }
}

